/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public abstract class SpongeRecipeRegistration
implements RecipeRegistration,
IFinishedRecipe {
    protected final ResourceLocation key;
    protected final IRecipeSerializer<?> serializer;
    protected final ResourceLocation advancementId;
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.builder();
    protected final String group;

    public static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S register(String spongeName, S recipeSerializer) {
        return (S)((IRecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (ResourceLocation)new ResourceLocation("sponge", spongeName), recipeSerializer));
    }

    public static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S register(ResourceLocation resourceLocation, S recipeSerializer) {
        return (S)((IRecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (ResourceLocation)resourceLocation, recipeSerializer));
    }

    public SpongeRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, Item resultItem, String group) {
        this.key = key;
        this.serializer = serializer;
        ItemGroup itemGroup = resultItem.getGroup();
        this.advancementId = new ResourceLocation(key.getNamespace(), "recipes/" + (itemGroup == null ? "uncategorized" : itemGroup.getPath()) + "/" + key.getPath());
        this.advancementBuilder.withCriterion("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(key)).withRewards(AdvancementRewards.Builder.recipe((ResourceLocation)key));
        this.group = group == null ? "" : group;
    }

    public static <C extends IInventory> IRecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction, Map<Character, Ingredient> ingredients, IRecipeSerializer<?> vanilla, IRecipeSerializer<?> sponge) {
        return SpongeRecipeRegistration.determineSerializer(resultStack, resultFunction, remainingItemsFunction, ingredients.values(), vanilla, sponge);
    }

    public static <C extends IInventory> IRecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction, Collection<Ingredient> ingredients, IRecipeSerializer<?> vanilla, IRecipeSerializer<?> sponge) {
        if (resultStack.hasTag() || resultFunction != null || remainingItemsFunction != null) {
            return sponge;
        }
        for (Ingredient value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return sponge;
        }
        return vanilla;
    }

    public ResourceLocation getID() {
        return this.key;
    }

    @Override
    public ResourceKey getKey() {
        return (ResourceKey)this.key;
    }

    public IRecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public JsonObject getRecipeJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", Registry.RECIPE_SERIALIZER.getKey(this.getSerializer()).toString());
        this.serialize(jsonobject);
        return jsonobject;
    }

    public void serialize(JsonObject json) {
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        this.serializeShape(json);
        this.serializeResult(json);
        this.serializeAdditional(json);
    }

    public abstract void serializeShape(JsonObject var1);

    public abstract void serializeResult(JsonObject var1);

    public void serializeAdditional(JsonObject json) {
    }

    public JsonObject getAdvancementJson() {
        return this.advancementBuilder.serialize();
    }

    public ResourceLocation getAdvancementID() {
        return this.advancementId;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        try {
            return DataFormats.JSON.get().read(this.getRecipeJson().toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

