/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeCookingRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeCookingRecipeSerializer;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public class SpongeCookingRecipeBuilder
extends SpongeCatalogBuilder<RecipeRegistration, CookingRecipe.Builder>
implements CookingRecipe.Builder.ResultStep,
CookingRecipe.Builder.IngredientStep,
CookingRecipe.Builder.EndStep {
    private IRecipeType type;
    private Ingredient ingredient;
    private net.minecraft.item.ItemStack result;
    private Function<IInventory, net.minecraft.item.ItemStack> resultFunction;
    private @Nullable Float experience;
    private @Nullable Integer cookingTime;
    private @Nullable String group;

    @Override
    public CookingRecipe.Builder.ResultStep ingredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.ingredient = (Ingredient)ingredient;
        return this;
    }

    @Override
    public CookingRecipe.Builder reset() {
        super.reset();
        this.type = null;
        this.ingredient = null;
        this.result = null;
        this.resultFunction = null;
        this.experience = null;
        this.cookingTime = null;
        this.group = null;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(ItemType result) {
        this.result = new net.minecraft.item.ItemStack((IItemProvider)((Item)result));
        this.resultFunction = null;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(ItemStack result) {
        this.result = ItemStackUtil.toNative(result);
        this.resultFunction = null;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        return this.result(result.createStack());
    }

    public CookingRecipe.Builder.EndStep result(Function<Inventory, ItemStack> resultFunction, ItemStack exemplaryResult) {
        this.result = ItemStackUtil.toNative(exemplaryResult);
        this.resultFunction = inv -> ItemStackUtil.toNative((ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep experience(double experience) {
        Preconditions.checkState((experience >= 0.0 ? 1 : 0) != 0, (Object)"The experience must be non-negative.");
        this.experience = Float.valueOf((float)experience);
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep cookingTime(int ticks) {
        this.cookingTime = ticks;
        return this;
    }

    @Override
    public CookingRecipe.Builder.IngredientStep type(RecipeType<CookingRecipe> type) {
        this.type = (IRecipeType)type;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep group(String group) {
        this.group = group;
        return this;
    }

    @Override
    protected RecipeRegistration build(ResourceKey key) {
        IRecipeSerializer<BlastingRecipe> serializer;
        Preconditions.checkNotNull((Object)this.type);
        Preconditions.checkNotNull((Object)this.ingredient);
        Preconditions.checkNotNull((Object)this.result);
        Preconditions.checkNotNull((Object)key);
        this.key = key;
        if (this.experience == null) {
            this.experience = Float.valueOf(0.0f);
        }
        List<Ingredient> ingredientList = Collections.singletonList(this.ingredient);
        if (this.type == IRecipeType.BLASTING) {
            if (this.cookingTime == null) {
                this.cookingTime = 100;
            }
            serializer = SpongeRecipeRegistration.determineSerializer(this.result, this.resultFunction, null, ingredientList, IRecipeSerializer.BLASTING, SpongeCookingRecipeSerializer.Blasting.SPONGE_BLASTING);
        } else if (this.type == IRecipeType.CAMPFIRE_COOKING) {
            if (this.cookingTime == null) {
                this.cookingTime = 600;
            }
            serializer = SpongeRecipeRegistration.determineSerializer(this.result, this.resultFunction, null, ingredientList, IRecipeSerializer.CAMPFIRE_COOKING, SpongeCookingRecipeSerializer.Campfire.SPONGE_CAMPFIRE_COOKING);
        } else if (this.type == IRecipeType.SMOKING) {
            if (this.cookingTime == null) {
                this.cookingTime = 100;
            }
            serializer = SpongeRecipeRegistration.determineSerializer(this.result, this.resultFunction, null, ingredientList, IRecipeSerializer.SMOKING, SpongeCookingRecipeSerializer.Smoking.SPONGE_SMOKING);
        } else if (this.type == IRecipeType.SMELTING) {
            if (this.cookingTime == null) {
                this.cookingTime = 200;
            }
            serializer = SpongeRecipeRegistration.determineSerializer(this.result, this.resultFunction, null, ingredientList, IRecipeSerializer.SMELTING, SpongeCookingRecipeSerializer.Smelting.SPONGE_SMELTING);
        } else {
            throw new IllegalArgumentException("Unknown RecipeType " + this.type);
        }
        return new SpongeCookingRecipeRegistration((ResourceLocation)this.key, serializer, this.group, this.ingredient, this.experience.floatValue(), this.cookingTime, this.result, this.resultFunction);
    }
}

