/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeFurnaceRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;

public abstract class SpongeCookingRecipeSerializer<R extends AbstractCookingRecipe>
implements IRecipeSerializer<R> {
    private final int defaultCookingTime;

    public SpongeCookingRecipeSerializer(int p_i50025_2_) {
        this.defaultCookingTime = p_i50025_2_;
    }

    public R read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.getString((JsonObject)json, (String)"group", (String)"");
        JsonElement jsonelement = JSONUtils.isJsonArray((JsonObject)json, (String)"ingredient") ? JSONUtils.getJsonArray((JsonObject)json, (String)"ingredient") : JSONUtils.getJsonObject((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = IngredientUtil.spongeDeserialize(jsonelement);
        String result = JSONUtils.getString((JsonObject)json, (String)"result");
        ResourceLocation resourcelocation = new ResourceLocation(result);
        ItemStack itemstack = new ItemStack((IItemProvider)Registry.ITEM.getValue(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        ItemStack spongeStack = ResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        Function<IInventory, ItemStack> resultFunction = ResultUtil.deserializeResultFunction(json);
        float exp = JSONUtils.getFloat((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = JSONUtils.getInt((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.create(recipeId, group, ingredient, spongeStack == null ? itemstack : spongeStack, resultFunction, exp, cookTime);
    }

    protected abstract R create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, Function<IInventory, ItemStack> var5, float var6, int var7);

    public R read(ResourceLocation recipeId, PacketBuffer buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void write(PacketBuffer buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public static class Campfire
    extends SpongeCookingRecipeSerializer<CampfireCookingRecipe> {
        public static SpongeCookingRecipeSerializer<CampfireCookingRecipe> SPONGE_CAMPFIRE_COOKING = SpongeRecipeRegistration.register("campfire_cooking", new Campfire());

        public Campfire() {
            super(100);
        }

        @Override
        protected CampfireCookingRecipe create(ResourceLocation recipeId, String group, Ingredient ingredient, ItemStack resultStack, Function<IInventory, ItemStack> resultFunction, float experience, int cookingTime) {
            return new SpongeCampfireCookingRecipe(recipeId, group, ingredient, resultStack, experience, cookingTime, resultFunction);
        }
    }

    public static class Smoking
    extends SpongeCookingRecipeSerializer<SmokingRecipe> {
        public static SpongeCookingRecipeSerializer<SmokingRecipe> SPONGE_SMOKING = SpongeRecipeRegistration.register("smoking", new Smoking());

        public Smoking() {
            super(100);
        }

        @Override
        protected SmokingRecipe create(ResourceLocation recipeId, String group, Ingredient ingredient, ItemStack resultStack, Function<IInventory, ItemStack> resultFunction, float experience, int cookingTime) {
            return new SpongeSmokingRecipe(recipeId, group, ingredient, resultStack, experience, cookingTime, resultFunction);
        }
    }

    public static class Blasting
    extends SpongeCookingRecipeSerializer<BlastingRecipe> {
        public static SpongeCookingRecipeSerializer<BlastingRecipe> SPONGE_BLASTING = SpongeRecipeRegistration.register("blasting", new Blasting());

        public Blasting() {
            super(100);
        }

        @Override
        protected BlastingRecipe create(ResourceLocation recipeId, String group, Ingredient ingredient, ItemStack resultStack, Function<IInventory, ItemStack> resultFunction, float experience, int cookingTime) {
            return new SpongeBlastingRecipe(recipeId, group, ingredient, resultStack, experience, cookingTime, resultFunction);
        }
    }

    public static class Smelting
    extends SpongeCookingRecipeSerializer<FurnaceRecipe> {
        public static SpongeCookingRecipeSerializer<FurnaceRecipe> SPONGE_SMELTING = SpongeRecipeRegistration.register("smelting", new Smelting());

        public Smelting() {
            super(200);
        }

        @Override
        protected FurnaceRecipe create(ResourceLocation recipeId, String group, Ingredient ingredient, ItemStack resultStack, Function<IInventory, ItemStack> resultFunction, float experience, int cookingTime) {
            return new SpongeFurnaceRecipe(recipeId, group, ingredient, resultStack, experience, cookingTime, resultFunction);
        }
    }
}

