/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.accessor.item.crafting.IngredientAccessor;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class IngredientUtil {
    public static org.spongepowered.api.item.recipe.crafting.Ingredient fromNative(Ingredient ingredient) {
        return (org.spongepowered.api.item.recipe.crafting.Ingredient)ingredient;
    }

    public static Ingredient toNative(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        return (Ingredient)ingredient;
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ItemType ... items) {
        IItemProvider[] providers = (IItemProvider[])Arrays.stream(items).map(item -> () -> (Item)item).toArray(IItemProvider[]::new);
        return IngredientUtil.fromNative(Ingredient.fromItems((IItemProvider[])providers));
    }

    @Nullable
    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ResourceKey tagKey) {
        Tag itemTag = ItemTags.getCollection().get((ResourceLocation)tagKey);
        if (itemTag == null) {
            return null;
        }
        return IngredientUtil.fromNative(Ingredient.fromTag((Tag)itemTag));
    }

    private static net.minecraft.item.ItemStack[] toNativeStacks(ItemStack[] stacks) {
        return (net.minecraft.item.ItemStack[])Arrays.stream(stacks).map(ItemStackUtil::toNative).toArray(net.minecraft.item.ItemStack[]::new);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromStacks(IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ResourceKey key, Predicate<ItemStack> predicate, ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromPredicate(key, predicate, IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }

    public static Ingredient spongeDeserialize(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (json.isJsonObject()) {
            JsonObject ingredientJson = json.getAsJsonObject();
            if (ingredientJson.has("sponge:type")) {
                String type;
                switch (type = JSONUtils.getString((JsonObject)ingredientJson, (String)"sponge:type")) {
                    case "sponge:stack": {
                        return new SpongeIngredient(IngredientUtil.spongeDeserializeItemList(ingredientJson));
                    }
                    case "sponge:predicate": {
                        return new SpongeIngredient(IngredientUtil.spongeDeserializePredicateItemList(ingredientJson));
                    }
                }
                throw new JsonSyntaxException("Unknown Sponge ingredient type " + type);
            }
            Ingredient.IItemList itemList = Ingredient.deserializeItemList((JsonObject)ingredientJson);
            return IngredientAccessor.accessor$fromItemListStream(Stream.of(itemList));
        }
        if (json.isJsonArray()) {
            JsonArray jsonarray = json.getAsJsonArray();
            if (jsonarray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return IngredientAccessor.accessor$fromItemListStream(StreamSupport.stream(jsonarray.spliterator(), false).map(p_209355_0_ -> Ingredient.deserializeItemList((JsonObject)JSONUtils.getJsonObject((JsonElement)p_209355_0_, (String)"item"))));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static Stream<? extends Ingredient.IItemList> spongeDeserializePredicateItemList(JsonObject json) {
        if (!json.has("sponge:item")) {
            throw new JsonParseException("Sponge Ingredient is missing sponge:item");
        }
        if (!json.has("sponge:predicate")) {
            throw new JsonParseException("Sponge Ingredient Predicate is missing sponge:predicate");
        }
        if (!json.get("sponge:item").isJsonArray()) {
            throw new JsonParseException("Sponge Ingredient sponge:item is not an object");
        }
        String id = JSONUtils.getString((JsonObject)json, (String)"sponge:predicate");
        Predicate<net.minecraft.item.ItemStack> predicate = SpongeIngredient.getCachedPredicate(id);
        if (predicate == null) {
            throw new JsonParseException("Sponge Ingredient Predicate not found: " + id);
        }
        JsonArray jsonArray = json.getAsJsonArray("sponge:item");
        return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(ResultUtil::deserializeItemStack).map(stacks -> new SpongePredicateItemList(id, predicate, (net.minecraft.item.ItemStack)stacks));
    }

    public static Stream<Ingredient.IItemList> spongeDeserializeItemList(JsonObject json) {
        if (!json.has("sponge:item")) {
            throw new JsonParseException("Sponge Ingredient is missing sponge:item");
        }
        if (!json.get("sponge:item").isJsonArray()) {
            throw new JsonParseException("Sponge Ingredient sponge:item is not an object");
        }
        JsonArray jsonArray = json.getAsJsonArray("sponge:item");
        return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(ResultUtil::deserializeItemStack).map(xva$0 -> new SpongeStackItemList((net.minecraft.item.ItemStack)xva$0));
    }
}

