/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.item.crafting.Ingredient;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.hooks.SpongeHooks;
import org.spongepowered.common.item.recipe.ingredient.SpongeItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeIngredient
extends Ingredient {
    private static final Map<String, Predicate<net.minecraft.item.ItemStack>> cachedPredicates = new HashMap<String, Predicate<net.minecraft.item.ItemStack>>();

    public SpongeIngredient(Stream<? extends Ingredient.IItemList> itemlist) {
        super(itemlist);
    }

    public SpongeIngredient(Ingredient.IItemList iItemList) {
        this(Stream.of(iItemList));
    }

    public static void clearCache() {
        cachedPredicates.clear();
    }

    public boolean test(net.minecraft.item.ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        for (Ingredient.IItemList acceptedItem : this.acceptedItems) {
            if (acceptedItem instanceof SpongeItemList) {
                if (!((SpongeItemList)acceptedItem).test(testStack)) continue;
                return true;
            }
            for (net.minecraft.item.ItemStack stack : acceptedItem.getStacks()) {
                if (stack.getItem() != testStack.getItem()) continue;
                return true;
            }
        }
        return false;
    }

    public static SpongeIngredient spongeFromStacks(net.minecraft.item.ItemStack ... stacks) {
        SpongeStackItemList itemList = new SpongeStackItemList(stacks);
        return new SpongeIngredient(itemList);
    }

    public static SpongeIngredient spongeFromPredicate(ResourceKey key, Predicate<ItemStack> predicate, net.minecraft.item.ItemStack ... exemplaryIngredients) {
        Predicate<net.minecraft.item.ItemStack> mcPredicate = stack -> predicate.test(ItemStackUtil.fromNative(stack));
        if (cachedPredicates.put(key.toString(), mcPredicate) != null) {
            SpongeHooks.logWarning("Predicate ingredient registered twice! {} was replaced.", key.toString());
        }
        SpongePredicateItemList itemList = new SpongePredicateItemList(key.toString(), mcPredicate, exemplaryIngredients);
        return new SpongeIngredient(itemList);
    }

    public static Predicate<net.minecraft.item.ItemStack> getCachedPredicate(String id) {
        return cachedPredicates.get(id);
    }
}

