/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SingleItemRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipe;

public class SpongeStonecuttingRecipeSerializer<R extends SingleItemRecipe>
implements IRecipeSerializer<R> {
    public static IRecipeSerializer<?> SPONGE_STONECUTTING = SpongeRecipeRegistration.register("stonecutting", new SpongeStonecuttingRecipeSerializer());

    public R read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.getString((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = IngredientUtil.spongeDeserialize(json.get("ingredient"));
        Function<IInventory, ItemStack> resultFunction = ResultUtil.deserializeResultFunction(json);
        ItemStack spongeStack = ResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        if (spongeStack != null) {
            return (R)((Object)new SpongeStonecuttingRecipe(recipeId, group, ingredient, spongeStack, resultFunction));
        }
        String type = JSONUtils.getString((JsonObject)json, (String)"result");
        int count = JSONUtils.getInt((JsonObject)json, (String)"count");
        ItemStack itemstack = new ItemStack((IItemProvider)Registry.ITEM.getOrDefault(new ResourceLocation(type)), count);
        return (R)((Object)new SpongeStonecuttingRecipe(recipeId, group, ingredient, itemstack, resultFunction));
    }

    public R read(ResourceLocation recipeId, PacketBuffer buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void write(PacketBuffer buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

