/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.client;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.client.LocalServer;
import org.spongepowered.api.entity.living.player.client.LocalPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.scheduler.ClientScheduler;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin_API
extends RecursiveEventLoop<Runnable>
implements SpongeClient {
    @Shadow
    public ClientWorld world;
    @Shadow
    public ClientPlayerEntity player;
    @Shadow
    @Nullable
    private NetworkManager networkManager;
    private final ClientScheduler api$scheduler = new ClientScheduler();

    @Shadow
    @Nullable
    public abstract IntegratedServer shadow$getIntegratedServer();

    public MinecraftMixin_API(String name) {
        super(name);
    }

    @Override
    public Optional<LocalPlayer> getPlayer() {
        return Optional.ofNullable((LocalPlayer)this.player);
    }

    @Override
    public Optional<LocalServer> getServer() {
        MinecraftBridge minecraftBridge = (MinecraftBridge)((Object)this);
        IntegratedServer integratedServer = minecraftBridge.bridge$getTemporaryIntegratedServer();
        if (integratedServer != null) {
            return Optional.ofNullable(integratedServer);
        }
        return Optional.ofNullable(this.shadow$getIntegratedServer());
    }

    @Override
    public Optional<org.spongepowered.api.world.client.ClientWorld> getWorld() {
        return Optional.ofNullable((org.spongepowered.api.world.client.ClientWorld)this.world);
    }

    @Override
    public Optional<ClientSideConnection> getConnection() {
        if (this.networkManager == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ClientSideConnection)this.networkManager.getNetHandler());
    }

    @Override
    public Game getGame() {
        return Sponge.getGame();
    }

    @Override
    public CauseStackManager getCauseStackManager() {
        return PhaseTracker.getCauseStackManager();
    }

    @Override
    public ClientScheduler getScheduler() {
        return this.api$scheduler;
    }

    @Override
    public boolean onMainThread() {
        return this.isOnExecutionThread();
    }
}

