/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.command.arguments;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MinMaxBoundsWrapped;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.advancements.criterion.MinMaxBounds_FloatBoundAccessor;
import org.spongepowered.common.accessor.advancements.criterion.MinMaxBounds_IntBoundAccessor;
import org.spongepowered.common.bridge.command.arguments.EntitySelectorParserBridge;
import org.spongepowered.common.command.selector.SpongeSelectorSortAlgorithm;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EntitySelectorParser.class})
public abstract class EntitySelectorParserMixin_API
implements Selector.Builder {
    @Shadow
    @Final
    private StringReader reader;
    @Shadow
    private int limit;
    @Shadow
    private BiConsumer<Vec3d, List<? extends net.minecraft.entity.Entity>> sorter;
    @Shadow
    private MinMaxBounds.FloatBound distance;
    @Shadow
    private MinMaxBounds.IntBound level;
    @Shadow
    private boolean includeNonPlayers;
    @Shadow
    private boolean currentWorldOnly;
    @Shadow
    private @Nullable Double x;
    @Shadow
    private @Nullable Double y;
    @Shadow
    private @Nullable Double z;
    @Shadow
    private @Nullable Double dx;
    @Shadow
    private @Nullable Double dy;
    @Shadow
    private @Nullable Double dz;
    @Shadow
    private MinMaxBoundsWrapped xRotation = MinMaxBoundsWrapped.UNBOUNDED;
    @Shadow
    private MinMaxBoundsWrapped yRotation = MinMaxBoundsWrapped.UNBOUNDED;
    @Shadow
    private Predicate<net.minecraft.entity.Entity> filter;
    @Shadow
    private boolean self;
    @Shadow
    private @Nullable String username;
    @Shadow
    private int cursorStart;
    @Shadow
    private @Nullable UUID uuid;
    @Shadow
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionHandler;
    @Shadow
    private boolean hasNameEquals;
    @Shadow
    private boolean hasNameNotEquals;
    @Shadow
    private boolean isLimited;
    @Shadow
    private boolean isSorted;
    @Shadow
    private boolean hasGamemodeEquals;
    @Shadow
    private boolean hasGamemodeNotEquals;
    @Shadow
    private boolean hasTeamEquals;
    @Shadow
    private boolean hasTeamNotEquals;
    @Shadow
    private @Nullable net.minecraft.entity.EntityType<?> type;
    @Shadow
    private boolean typeInverse;
    @Shadow
    private boolean hasScores;
    @Shadow
    private boolean hasAdvancements;
    @Shadow
    private boolean checkPermission;
    private @Nullable Map<String, Range<@NonNull Integer>> api$scores;
    private @Nullable Object2BooleanOpenHashMap<String> api$advancement;
    private @Nullable Map<String, Object2BooleanOpenHashMap<String>> api$criterion;
    private boolean api$forceSelf;

    @Shadow
    public abstract void shadow$setLimited(boolean var1);

    @Shadow
    public abstract void shadow$setSorted(boolean var1);

    @Shadow
    public abstract void shadow$setX(double var1);

    @Shadow
    public abstract void shadow$setY(double var1);

    @Shadow
    public abstract void shadow$setZ(double var1);

    @Shadow
    public abstract void shadow$setDx(double var1);

    @Shadow
    public abstract void shadow$setDy(double var1);

    @Shadow
    public abstract void shadow$setDz(double var1);

    @Shadow
    public abstract void shadow$setIncludeNonPlayers(boolean var1);

    @Shadow
    public abstract EntitySelector shadow$build();

    @Shadow
    public abstract void shadow$addFilter(Predicate<net.minecraft.entity.Entity> var1);

    @Override
    public @NonNull Selector.Builder applySelectorType(Supplier<SelectorType> selectorType) {
        return this.applySelectorType(selectorType.get());
    }

    @Override
    public @NonNull Selector.Builder applySelectorType(@NonNull SelectorType selectorType) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$parseSelector(selectorType);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Could not parse provided SelectorType", commandSyntaxException);
        }
        return this;
    }

    @Override
    public @NonNull Selector.Builder includeSelf() {
        this.api$forceSelf = true;
        return this;
    }

    @Override
    public @NonNull Selector.Builder setLimit(int limit) {
        this.limit = limit;
        this.shadow$setLimited(limit != Integer.MAX_VALUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder setDistance(@NonNull Range<@NonNull Double> range) {
        Preconditions.checkArgument((range.getMin() == null || range.getMin() >= 0.0 ? 1 : 0) != 0, (Object)"min must be non-negative");
        Preconditions.checkArgument((range.getMax() == null || range.getMax() >= 0.0 ? 1 : 0) != 0, (Object)"max must be non-negative");
        this.distance = MinMaxBounds_FloatBoundAccessor.accessor$init(this.api$floatFromDouble(range.getMin(), Function.identity()), this.api$floatFromDouble(range.getMax(), Function.identity()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder setVolume(@NonNull Vector3d corner1, @NonNull Vector3d corner2) {
        Vector3d minPoint = corner1.min(corner2);
        Vector3d distance = corner1.max(corner2).sub(minPoint);
        this.shadow$setX(minPoint.getX());
        this.shadow$setY(minPoint.getY());
        this.shadow$setZ(minPoint.getZ());
        this.shadow$setDx(distance.getX());
        this.shadow$setDy(distance.getY());
        this.shadow$setDz(distance.getZ());
        return this;
    }

    @Override
    public @NonNull Selector.Builder setSortAlgorithm(@NonNull Supplier<SelectorSortAlgorithm> algorithm) {
        return this.setSortAlgorithm(algorithm.get());
    }

    @Override
    public @NonNull Selector.Builder setSortAlgorithm(@NonNull SelectorSortAlgorithm algorithm) {
        Preconditions.checkArgument((boolean)(algorithm instanceof SpongeSelectorSortAlgorithm), (Object)"Must be a SpongeSelectorSortAlgorithm");
        this.shadow$setSorted(true);
        this.sorter = ((SpongeSelectorSortAlgorithm)algorithm).getSortAlgorithm();
        return this;
    }

    @Override
    public @NonNull Selector.Builder advancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, false);
    }

    @Override
    public @NonNull Selector.Builder notAdvancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, true);
    }

    @Override
    public @NonNull Selector.Builder advancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, false);
    }

    @Override
    public @NonNull Selector.Builder notAdvancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, true);
    }

    @Override
    public @NonNull Selector.Builder setDataView(@NonNull DataView view) {
        try {
            String json = DataFormats.JSON.get().write(view);
            this.api$handle("nbt", json);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JSON representation of DataView", e);
        }
    }

    @Override
    public @NonNull Selector.Builder notEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type) {
        return this.notEntityType(type.get());
    }

    @Override
    public @NonNull Selector.Builder notEntityType(@NonNull EntityType<@NonNull ?> type) {
        this.api$handle("type", "!" + type.getKey().asString());
        return this;
    }

    @Override
    public @NonNull Selector.Builder entityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type, boolean inherit) {
        return this.entityType(type.get(), inherit);
    }

    @Override
    public @NonNull Selector.Builder entityType(@NonNull EntityType<@NonNull ?> type, boolean inherit) {
        this.api$handle("type", String.format("%s%s", inherit ? "#" : "", type.getKey().asString()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder setExperienceLevel(@NonNull Range<@NonNull Integer> range) {
        Preconditions.checkArgument((range.getMin() == null || range.getMin() >= 0 ? 1 : 0) != 0, (Object)"min must be non-negative");
        Preconditions.checkArgument((range.getMax() == null || range.getMax() >= 0 ? 1 : 0) != 0, (Object)"max must be non-negative");
        this.level = MinMaxBounds_IntBoundAccessor.accessor$init(range.getMin(), range.getMax());
        this.shadow$setIncludeNonPlayers(false);
        return this;
    }

    @Override
    public @NonNull Selector.Builder gameMode(@NonNull Supplier<@NonNull GameMode> mode) {
        return this.gameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder gameMode(@NonNull GameMode mode) {
        this.api$handle("gamemode", mode.getKey().getValue(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder notGameMode(@NonNull Supplier<@NonNull GameMode> mode) {
        return this.notGameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder notGameMode(@NonNull GameMode mode) {
        this.api$handle("gamemode", mode.getKey().getValue(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder noTeam() {
        this.api$handle("team", "", Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder anyTeam() {
        this.api$handle("team", "", Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder team(@NonNull Team team) {
        this.api$handle("team", team.getName(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder notTeam(@NonNull Team team) {
        this.api$handle("team", team.getName(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder name(@NonNull String name) {
        this.api$handle("name", name, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder notName(@NonNull String name) {
        this.api$handle("name", name, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder score(@NonNull Score score, @NonNull Range<@NonNull Integer> range) {
        if (this.api$scores == null) {
            this.api$scores = new HashMap<String, Range<Integer>>();
        }
        this.api$scores.put(score.getName().toString(), range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder tag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder notTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder setPitch(@NonNull Range<@NonNull Double> range) {
        this.xRotation = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder setYaw(@NonNull Range<@NonNull Double> range) {
        this.yRotation = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder filter(@NonNull Predicate<@NonNull Entity> filter) {
        this.shadow$addFilter(filter);
        return this;
    }

    @Override
    public @NonNull Selector build() throws IllegalStateException {
        ArrayList entries;
        if (this.api$advancement != null || this.api$criterion != null) {
            entries = new ArrayList();
            if (this.api$advancement != null) {
                this.api$advancement.object2BooleanEntrySet().fastForEach(x -> entries.add((String)x.getKey() + "=" + x.getBooleanValue()));
            }
            if (this.api$criterion != null) {
                this.api$criterion.forEach((key, value) -> value.object2BooleanEntrySet().fastForEach(x -> entries.add(key + "={" + (String)x.getKey() + "=" + x.getBooleanValue() + "}")));
            }
            this.api$handle("advancements", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$advancement = null;
            this.api$criterion = null;
        }
        if (this.api$scores != null) {
            entries = new ArrayList();
            this.api$scores.forEach((key, range) -> entries.add(key + "=" + this.api$intRangeToStringRepresentation((Range<Integer>)range)));
            this.api$handle("scores", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$scores = null;
        }
        if (this.api$forceSelf) {
            this.self = true;
        }
        return (Selector)this.shadow$build();
    }

    @Override
    public @NonNull Selector.Builder reset() {
        this.sorter = EntitySelectorParser.ARBITRARY;
        this.distance = MinMaxBounds.FloatBound.UNBOUNDED;
        this.level = MinMaxBounds.IntBound.UNBOUNDED;
        this.includeNonPlayers = false;
        this.currentWorldOnly = false;
        this.x = null;
        this.y = null;
        this.z = null;
        this.dx = null;
        this.dy = null;
        this.dz = null;
        this.xRotation = MinMaxBoundsWrapped.UNBOUNDED;
        this.yRotation = MinMaxBoundsWrapped.UNBOUNDED;
        this.filter = x -> true;
        this.self = false;
        this.username = null;
        this.cursorStart = 0;
        this.uuid = null;
        this.hasNameEquals = false;
        this.hasNameNotEquals = false;
        this.isLimited = false;
        this.isSorted = false;
        this.hasGamemodeEquals = false;
        this.hasGamemodeNotEquals = false;
        this.hasTeamEquals = false;
        this.hasTeamNotEquals = false;
        this.type = null;
        this.typeInverse = false;
        this.hasScores = false;
        this.hasAdvancements = false;
        this.checkPermission = false;
        this.reader.setCursor(0);
        this.suggestionHandler = EntitySelectorParser.SUGGEST_NONE;
        this.api$forceSelf = false;
        return this;
    }

    private @NonNull Selector.Builder api$advancement(@NonNull Advancement advancement, boolean inverted) {
        if (this.api$advancement == null) {
            this.api$advancement = new Object2BooleanOpenHashMap();
        }
        this.api$advancement.put((Object)advancement.getKey().asString(), inverted);
        return this;
    }

    private @NonNull Selector.Builder api$advancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion, boolean inverted) {
        if (this.api$criterion == null) {
            this.api$criterion = new HashMap<String, Object2BooleanOpenHashMap<String>>();
        }
        this.api$criterion.computeIfAbsent(advancement.getKey().toString(), k -> new Object2BooleanOpenHashMap()).put((Object)criterion.getName(), inverted);
        return this;
    }

    private void api$handle(@NonNull String name, @NonNull String value) {
        this.api$handle(name, value, Tristate.UNDEFINED);
    }

    private void api$handle(@NonNull String name, @NonNull String value, @NonNull Tristate invert) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$handleValue(name, value, invert);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not create selector criteria based on input", ex);
        }
    }

    private @Nullable Float api$floatFromDouble(@Nullable Double d, Function<Float, Float> mapping) {
        if (d == null) {
            return null;
        }
        return mapping.apply(Float.valueOf(d.floatValue()));
    }

    private MinMaxBoundsWrapped api$getWrappedBounds(Range<@NonNull Double> range) {
        Float a = this.api$floatFromDouble(range.getMin(), MathHelper::wrapDegrees);
        Float b = this.api$floatFromDouble(range.getMax(), MathHelper::wrapDegrees);
        if (a == null) {
            return new MinMaxBoundsWrapped(null, b);
        }
        if (b == null) {
            return new MinMaxBoundsWrapped(a, null);
        }
        if (a.floatValue() <= b.floatValue()) {
            return new MinMaxBoundsWrapped(a, b);
        }
        return new MinMaxBoundsWrapped(b, a);
    }

    private String api$intRangeToStringRepresentation(@NonNull Range<@NonNull Integer> range) {
        if (range.getMin() != null && range.getMax() != null && range.getMin().intValue() == range.getMax().intValue()) {
            return String.valueOf(range.getMax());
        }
        return String.format("%s..%s", range.getMin() == null ? "" : String.valueOf(range.getMin()), range.getMax() == null ? "" : String.valueOf(range.getMax()));
    }
}

