/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$")})
public abstract class EntityMixin_API
implements Entity {
    @Shadow
    public float rotationYaw;
    @Shadow
    public float rotationPitch;
    @Shadow
    public boolean removed;
    @Final
    @Shadow
    protected Random rand;
    @Shadow
    public int ticksExisted;
    @Shadow
    public DimensionType dimension;
    @Shadow
    protected UUID entityUniqueID;
    @Shadow
    @Final
    private net.minecraft.entity.EntityType<?> type;

    @Shadow
    public abstract double shadow$getPosX();

    @Shadow
    public abstract double shadow$getPosY();

    @Shadow
    public abstract double shadow$getPosZ();

    @Shadow
    public abstract World shadow$getEntityWorld();

    @Shadow
    @Nullable
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    public abstract void shadow$setPosition(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$remove();

    @Shadow
    public abstract UUID shadow$getUniqueID();

    @Shadow
    public abstract void shadow$setFire(int var1);

    @Shadow
    public abstract boolean shadow$attackEntityFrom(DamageSource var1, float var2);

    @Shadow
    public abstract int shadow$getEntityId();

    @Shadow
    public abstract void shadow$playSound(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract void shadow$setRotation(float var1, float var2);

    @Shadow
    public abstract AxisAlignedBB shadow$getBoundingBox();

    @Shadow
    public abstract boolean shadow$writeUnlessRemoved(CompoundNBT var1);

    @Shadow
    @Nullable
    public abstract ITextComponent shadow$getCustomName();

    @Shadow
    public abstract ITextComponent shadow$getDisplayName();

    @Override
    public Random getRandom() {
        return this.rand;
    }

    @Override
    public Vector3d getPosition() {
        return new Vector3d(this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ());
    }

    public ServerLocation getLocation() {
        return ServerLocation.of((ServerWorld)this.shadow$getEntityWorld(), this.getPosition());
    }

    @Override
    public boolean setLocation(ServerLocation location) {
        Preconditions.checkNotNull((Object)location, (Object)"The location was null!");
        return ((EntityBridge)((Object)this)).bridge$setLocation(location);
    }

    @Override
    public boolean setLocationAndRotation(ServerLocation location, Vector3d rotation) {
        if (this.setLocation(location)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    @Override
    public Vector3d getScale() {
        return Vector3d.ONE;
    }

    @Override
    public void setScale(Vector3d scale) {
    }

    @Override
    public Transform getTransform() {
        return Transform.of(this.getPosition(), this.getRotation(), this.getScale());
    }

    @Override
    public boolean setTransform(Transform transform) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return false;
        }
        Preconditions.checkNotNull((Object)transform, (Object)"The transform cannot be null!");
        Vector3d position = transform.getPosition();
        this.shadow$setPosition(position.getX(), position.getY(), position.getZ());
        this.setRotation(transform.getRotation());
        this.setScale(transform.getScale());
        if (!((WorldBridge)this.shadow$getEntityWorld()).bridge$isFake()) {
            ((net.minecraft.world.server.ServerWorld)this.shadow$getEntityWorld()).chunkCheck((net.minecraft.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean transferToWorld(ServerWorld world, Vector3d position) {
        Preconditions.checkNotNull((Object)world, (Object)"World was null!");
        Preconditions.checkNotNull((Object)position, (Object)"Position was null!");
        return this.setLocation(ServerLocation.of(world, position));
    }

    @Override
    public Vector3d getRotation() {
        return new Vector3d(this.rotationPitch, this.rotationYaw, 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((net.minecraft.entity.Entity)this instanceof ServerPlayerEntity && ((ServerPlayerEntity)((net.minecraft.entity.Entity)this)).connection != null) {
            ((ServerPlayerEntity)((net.minecraft.entity.Entity)this)).connection.setPlayerLocation(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class));
        } else {
            if (!this.shadow$getEntityWorld().isRemote) {
                ((ServerWorldBridge)((Object)this.getWorld())).bridge$addEntityRotationUpdate((net.minecraft.entity.Entity)this, rotation);
            }
            this.shadow$setRotation((float)rotation.getY(), (float)rotation.getX());
        }
    }

    @Override
    public Optional<AABB> getBoundingBox() {
        AxisAlignedBB boundingBox = this.shadow$getBoundingBox();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isLoaded() {
        return !this.isRemoved();
    }

    @Intrinsic
    public void entity$remove() {
        this.shadow$remove();
    }

    @Override
    public boolean damage(double damage, org.spongepowered.api.event.cause.entity.damage.source.DamageSource damageSource) {
        if (!(damageSource instanceof DamageSource)) {
            SpongeCommon.getLogger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.shadow$attackEntityFrom((DamageSource)damageSource, (float)damage);
    }

    public EntityType getType() {
        return (EntityType)this.type;
    }

    @Override
    public UUID getUniqueId() {
        return this.entityUniqueID;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Transform transform = this.getTransform();
        CompoundNBT compound = new CompoundNBT();
        this.shadow$writeUnlessRemoved(compound);
        DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Entity.CLASS, this.getClass().getName()).set(Queries.WORLD_KEY, ((ServerWorld)this.getWorld()).getKey().getFormatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, transform.getPosition().getX()).set(Queries.POSITION_Y, transform.getPosition().getY()).set(Queries.POSITION_Z, transform.getPosition().getZ()).getContainer().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, transform.getRotation().getX()).set(Queries.POSITION_Y, transform.getRotation().getY()).set(Queries.POSITION_Z, transform.getRotation().getZ()).getContainer().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, transform.getScale().getX()).set(Queries.POSITION_Y, transform.getScale().getY()).set(Queries.POSITION_Z, transform.getScale().getZ()).getContainer().set(Constants.Entity.TYPE, this.getType().getKey()).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        return container;
    }

    @Override
    public Entity copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            CompoundNBT compound = new CompoundNBT();
            this.shadow$writeUnlessRemoved(compound);
            net.minecraft.entity.Entity entity = net.minecraft.entity.EntityType.loadEntityAndExecute((CompoundNBT)compound, (World)this.shadow$getEntityWorld(), createdEntity -> {
                compound.putUniqueId("UUID", createdEntity.getUniqueID());
                createdEntity.read(compound);
                return createdEntity;
            });
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public boolean canSee(Entity entity) {
        Optional optional = entity.get(Keys.VANISH);
        return (!optional.isPresent() || (Boolean)optional.get() == false) && !((VanishableBridge)((Object)entity)).bridge$isVanished();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return (EntitySnapshot)EntitySnapshot.builder().from(this).build();
    }

    @Override
    public EntityArchetype createArchetype() {
        return EntityArchetype.builder().from(this).build();
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        HashSet values = new HashSet();
        values.add(this.displayName().asImmutable());
        values.add(this.fallDistance().asImmutable());
        values.add(this.passengers().asImmutable());
        values.add(this.onGround().asImmutable());
        values.add(this.velocity().asImmutable());
        values.add(this.gravityAffected().asImmutable());
        values.add(this.silent().asImmutable());
        this.baseVehicle().map(Value::asImmutable).ifPresent(values::add);
        this.creator().map(Value::asImmutable).ifPresent(values::add);
        this.notifier().map(Value::asImmutable).ifPresent(values::add);
        this.fireTicks().map(Value::asImmutable).ifPresent(values::add);
        this.fireImmuneTicks().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

