/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.command.Commands;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.teleport.TeleportHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.scheduler.ServerScheduler;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.UsernameCache;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.storage.SpongePlayerDataManager;
import org.spongepowered.common.world.teleport.SpongeTeleportHelper;

@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=Server.class, prefix="server$")})
public abstract class MinecraftServerMixin_API
extends RecursiveEventLoop<TickDelayedTask>
implements SpongeServer {
    @Shadow
    @Final
    public long[] tickTimeArray;
    private Iterable<? extends Audience> audiences;
    private ServerScheduler api$scheduler;
    private SpongeTeleportHelper api$teleportHelper;
    private SpongePlayerDataManager api$playerDataHandler;
    private UsernameCache api$usernameCache;
    private Audience api$broadcastAudience;
    private ServerScoreboard api$scoreboard;
    private GameProfileManager api$profileManager;
    private SpongeUserManager api$userManager;

    @Shadow
    public abstract PlayerList shadow$getPlayerList();

    @Shadow
    public abstract boolean shadow$isServerInOnlineMode();

    @Shadow
    public abstract String shadow$getMOTD();

    @Shadow
    public abstract int shadow$getTickCounter();

    @Shadow
    public abstract void shadow$initiateShutdown(boolean var1);

    @Shadow
    public abstract int shadow$getMaxPlayerIdleMinutes();

    @Shadow
    public abstract void shadow$setPlayerIdleTimeout(int var1);

    public MinecraftServerMixin_API(String name) {
        super(name);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void api$initializeSpongeFields(File p_i50590_1_, Proxy p_i50590_2_, DataFixer dataFixerIn, Commands p_i50590_4_, YggdrasilAuthenticationService p_i50590_5_, MinecraftSessionService p_i50590_6_, GameProfileRepository p_i50590_7_, PlayerProfileCache p_i50590_8_, IChunkStatusListenerFactory p_i50590_9_, String p_i50590_10_, CallbackInfo ci) {
        this.api$scheduler = new ServerScheduler();
        this.api$playerDataHandler = new SpongePlayerDataManager(this);
        this.api$teleportHelper = new SpongeTeleportHelper();
        this.api$userManager = new SpongeUserManager(this);
    }

    public @NonNull Iterable<? extends Audience> audiences() {
        if (this.audiences == null) {
            this.audiences = Iterables.concat((Iterable)this.shadow$getPlayerList().getPlayers(), Collections.singleton(Sponge.getGame().getSystemSubject()));
        }
        return this.audiences;
    }

    @Override
    public ChunkLayout getChunkLayout() {
        return SpongeChunkLayout.instance;
    }

    @Override
    public Audience getBroadcastAudience() {
        if (this.api$broadcastAudience == null) {
            this.api$broadcastAudience = this;
        }
        return this.api$broadcastAudience;
    }

    @Override
    public void setBroadcastAudience(Audience channel) {
        this.api$broadcastAudience = (Audience)Preconditions.checkNotNull((Object)channel, (Object)"channel");
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        return Optional.empty();
    }

    @Override
    public boolean hasWhitelist() {
        return this.shadow$getPlayerList().isWhiteListEnabled();
    }

    @Override
    public void setHasWhitelist(boolean enabled) {
        this.shadow$getPlayerList().setWhiteListEnabled(enabled);
    }

    @Override
    public boolean getOnlineMode() {
        return this.shadow$isServerInOnlineMode();
    }

    @Override
    public UserManager getUserManager() {
        return this.api$userManager;
    }

    @Override
    public TeleportHelper getTeleportHelper() {
        return this.api$teleportHelper;
    }

    @Override
    public Collection<ServerPlayer> getOnlinePlayers() {
        if (this.shadow$getPlayerList() == null || this.shadow$getPlayerList().getPlayers() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.shadow$getPlayerList().getPlayers());
    }

    @Override
    public Optional<ServerPlayer> getPlayer(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId);
        if (this.shadow$getPlayerList() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$getPlayerList().getPlayerByUUID(uniqueId));
    }

    @Override
    public Optional<ServerPlayer> getPlayer(String name) {
        if (this.shadow$getPlayerList() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$getPlayerList().getPlayerByUsername(name));
    }

    @Override
    public Component getMotd() {
        return SpongeAdventure.legacySection(this.shadow$getMOTD());
    }

    @Override
    public int getMaxPlayers() {
        if (this.shadow$getPlayerList() == null) {
            return 0;
        }
        return this.shadow$getPlayerList().getMaxPlayers();
    }

    @Override
    public int getRunningTimeTicks() {
        return this.shadow$getTickCounter();
    }

    @Override
    public double getTicksPerSecond() {
        double nanoSPerTick = MathHelper.average((long[])this.tickTimeArray);
        return 1000.0 / Math.max(50.0, nanoSPerTick / 1000000.0);
    }

    @Override
    public int getTargetTicksPerSecond() {
        return 20;
    }

    @Override
    public void shutdown() {
        this.shadow$initiateShutdown(false);
    }

    @Override
    public void shutdown(Component kickMessage) {
        Preconditions.checkNotNull((Object)kickMessage);
        for (ServerPlayer player : this.getOnlinePlayers()) {
            player.kick(kickMessage);
        }
        this.shadow$initiateShutdown(false);
    }

    @Override
    public GameProfileManager getGameProfileManager() {
        if (this.api$profileManager == null) {
            this.api$profileManager = new SpongeGameProfileManager(this);
        }
        return this.api$profileManager;
    }

    @Override
    public Optional<ResourcePack> getDefaultResourcePack() {
        return Optional.ofNullable(((MinecraftServerBridge)((Object)this)).bridge$getResourcePack());
    }

    public Optional<Scoreboard> getServerScoreboard() {
        if (this.api$scoreboard == null) {
            ServerWorld world = this.getWorldManager().getDefaultWorld();
            if (world == null) {
                return Optional.empty();
            }
            this.api$scoreboard = world.getScoreboard();
        }
        return Optional.of((Scoreboard)this.api$scoreboard);
    }

    @Override
    public int getPlayerIdleTimeout() {
        return this.shadow$getMaxPlayerIdleMinutes();
    }

    @Intrinsic
    public void server$setPlayerIdleTimeout(int timeout) {
        this.shadow$setPlayerIdleTimeout(timeout);
    }

    @Override
    public Game getGame() {
        return Sponge.getGame();
    }

    @Override
    public CauseStackManager getCauseStackManager() {
        return PhaseTracker.getCauseStackManager();
    }

    @Override
    public ServerScheduler getScheduler() {
        return this.api$scheduler;
    }

    @Override
    public boolean onMainThread() {
        return this.isOnExecutionThread();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SpongePlayerDataManager getPlayerDataManager() {
        return this.api$playerDataHandler;
    }

    @Override
    public UsernameCache getUsernameCache() {
        if (this.api$usernameCache == null) {
            this.api$usernameCache = new UsernameCache(this);
        }
        return this.api$usernameCache;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.shadow$getPlayerList().sendMessage(SpongeAdventure.asVanilla(message));
    }

    @Override
    public ServiceProvider.ServerScoped getServiceProvider() {
        return ((MinecraftServerBridge)((Object)this)).bridge$getServiceProvider();
    }
}

