/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.entity.MobEntityAccessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={IWorld.class})
public interface IWorldMixin_API<T extends ProtoWorld<T>>
extends ProtoWorld<T> {
    @Shadow
    public long shadow$getSeed();

    @Shadow
    public World shadow$getWorld();

    @Shadow
    public DifficultyInstance shadow$getDifficultyForLocation(BlockPos var1);

    @Shadow
    public AbstractChunkProvider shadow$getChunkProvider();

    @Shadow
    public boolean shadow$chunkExists(int var1, int var2);

    @Shadow
    public Random shadow$getRandom();

    @Override
    default public boolean setBiome(int x, int y, int z, BiomeType biome) {
        IChunk iChunk = ((IWorld)this).getChunk(x >> 4, z >> 4, ChunkStatus.BIOMES, true);
        if (iChunk == null) {
            return false;
        }
        return ((ProtoChunk)iChunk).setBiome(x, y, z, biome);
    }

    @Override
    default public Vector3i getBlockMin() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i getBlockMax() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public Vector3i getBlockSize() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    @Override
    default public boolean containsBlock(int x, int y, int z) {
        return this.shadow$chunkExists(x >> 4, z >> 4);
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        return this.shadow$chunkExists(x >> 4, z >> 4);
    }

    @Override
    default public Optional<Entity> getEntity(UUID uuid) {
        return Optional.empty();
    }

    @Override
    default public Random getRandom() {
        return this.shadow$getRandom();
    }

    @Override
    default public long getSeed() {
        return this.shadow$getSeed();
    }

    @Override
    default public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.impl$createEntity(type, position, false);
    }

    @Override
    default public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.impl$createEntity(type, position, true);
    }

    @Override
    default public Optional<Entity> createEntity(DataContainer entityContainer) {
        throw new UnsupportedOperationException("Implement me");
    }

    @Override
    default public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        throw new UnsupportedOperationException("Implement me");
    }

    default public <E extends Entity> E impl$createEntity(EntityType<E> type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(type, (Object)"The entity type cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null!");
        if (type == net.minecraft.entity.EntityType.PLAYER) {
            throw new IllegalArgumentException("Cannot construct " + type.getKey() + " please look to using entity types correctly!");
        }
        LightningBoltEntity entity = null;
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        World thisWorld = this.shadow$getWorld();
        if (type == net.minecraft.entity.EntityType.LIGHTNING_BOLT) {
            entity = new LightningBoltEntity(thisWorld, x, y, z, false);
        }
        if (type == net.minecraft.entity.EntityType.ENDER_PEARL) {
            ArmorStandEntity tempEntity = new ArmorStandEntity(thisWorld, x, y, z);
            tempEntity.setPosition(tempEntity.getPosX(), tempEntity.getPosY() - (double)tempEntity.getEyeHeight(), tempEntity.getPosZ());
            entity = new EnderPearlEntity(thisWorld, (LivingEntity)tempEntity);
            ((EnderPearl)entity).offer(Keys.SHOOTER, UnknownProjectileSource.UNKNOWN);
        }
        if (type == net.minecraft.entity.EntityType.FALLING_BLOCK) {
            entity = new FallingBlockEntity(thisWorld, x, y, z, Blocks.SAND.getDefaultState());
        }
        if (type == net.minecraft.entity.EntityType.ITEM) {
            entity = new ItemEntity(thisWorld, x, y, z, new ItemStack((IItemProvider)Blocks.STONE));
        }
        if (entity == null) {
            try {
                entity = ((net.minecraft.entity.EntityType)type).create(thisWorld);
                entity.setPosition(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + type.getKey(), e);
            }
        }
        if (naturally && entity instanceof MobEntity) {
            DifficultyInstance difficulty = this.shadow$getDifficultyForLocation(new BlockPos(x, y, z));
            ((MobEntityAccessor)entity).accessor$setEquipmentBasedOnDifficulty(difficulty);
        }
        if (entity instanceof PaintingEntity) {
            ((PaintingEntity)entity).art = PaintingType.KEBAB;
        }
        return (E)((Entity)entity);
    }

    @Override
    default public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        NonNullList entitiesToSpawn = NonNullList.create();
        entities.forEach(((List)entitiesToSpawn)::add);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().getCurrentCause(), (List<Entity>)entitiesToSpawn);
        if (Sponge.getEventManager().post(event)) {
            return ImmutableList.of();
        }
        for (Entity entity : event.getEntities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Entity entity : event.getEntities()) {
            builder.add((Object)entity);
        }
        return builder.build();
    }

    @Override
    default public boolean spawnEntity(Entity entity) {
        Objects.requireNonNull(entity);
        return ((IWorld)this).addEntity((net.minecraft.entity.Entity)entity);
    }

    @Override
    default public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        if (!World.isValid((BlockPos)new BlockPos(x, y, z))) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        try (@Nullable PhaseContext<@NonNull ?> context = PluginPhase.State.BLOCK_WORKER.switchIfNecessary(PhaseTracker.SERVER);){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = ((IWorld)this).setBlockState(new BlockPos(x, y, z), (net.minecraft.block.BlockState)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }
}

