/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command.impl;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.impl.DifficultyCommand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DifficultyCommand.class})
public abstract class DifficultyCommandMixin {
    @Shadow
    @Final
    private static DynamicCommandExceptionType FAILED_EXCEPTION;

    @Overwrite
    public static int setDifficulty(CommandSource source, Difficulty difficulty) throws CommandSyntaxException {
        if (source.getWorld().getDifficulty() == difficulty) {
            throw FAILED_EXCEPTION.create((Object)difficulty.getTranslationKey());
        }
        source.getWorld().getWorldInfo().setDifficulty(difficulty);
        source.sendFeedback((ITextComponent)new TranslationTextComponent("commands.difficulty.success", new Object[]{difficulty.getDisplayName()}), true);
        return 0;
    }
}

