/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import co.aikar.timings.Timing;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.TicketType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.DismountType;
import org.spongepowered.api.event.cause.entity.DismountTypes;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.InvulnerableTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.bridge.world.PlatformITeleporterBridge;
import org.spongepowered.common.bridge.world.PlatformServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.MinecraftBlockDamageSource;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.DimensionChangeResult;
import org.spongepowered.common.world.portal.WrappedITeleporterPortalType;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.entity.Entity.class})
public abstract class EntityMixin
implements EntityBridge,
PlatformEntityBridge,
VanishableBridge,
InvulnerableTrackedBridge,
TimingBridge,
CommandSourceProviderBridge,
DataCompoundHolder {
    @Shadow
    public World world;
    @Shadow
    public float rotationYaw;
    @Shadow
    public float rotationPitch;
    @Shadow
    public int hurtResistantTime;
    @Shadow
    public boolean removed;
    @Shadow
    public float prevDistanceWalkedModified;
    @Shadow
    public float distanceWalkedModified;
    @Shadow
    @Final
    protected Random rand;
    @Shadow
    @Final
    protected EntityDataManager dataManager;
    @Shadow
    public DimensionType dimension;
    @Shadow
    public float prevRotationYaw;
    @Shadow
    protected int portalCounter;
    @Shadow
    public boolean collided;
    @Shadow
    @Nullable
    private net.minecraft.entity.Entity ridingEntity;
    @Shadow
    @Final
    private List<net.minecraft.entity.Entity> passengers;
    @Shadow
    public boolean onGround;
    @Shadow
    public float fallDistance;
    private boolean impl$isConstructing = true;
    private boolean impl$untargetable = false;
    private boolean impl$isVanished = false;
    private boolean impl$pendingVisibilityUpdate = false;
    private int impl$visibilityTicks = 0;
    private boolean impl$collision = true;
    private boolean impl$invulnerable = false;
    private boolean impl$transient = false;
    protected boolean impl$hasCustomFireImmuneTicks = false;
    protected short impl$fireImmuneTicks = 0;
    private CompoundNBT impl$customDataCompound;

    @Shadow
    public abstract void shadow$setPosition(double var1, double var3, double var5);

    @Shadow
    public abstract double shadow$getPosX();

    @Shadow
    public abstract double shadow$getPosZ();

    @Shadow
    public abstract double shadow$getPosY();

    @Shadow
    public abstract void shadow$remove();

    @Shadow
    public abstract void shadow$setCustomName(@Nullable ITextComponent var1);

    @Shadow
    public abstract boolean shadow$attackEntityFrom(DamageSource var1, float var2);

    @Shadow
    public abstract int shadow$getEntityId();

    @Shadow
    public abstract boolean shadow$isBeingRidden();

    @Shadow
    public abstract void shadow$playSound(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract void shadow$removePassenger(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract boolean shadow$isInvisible();

    @Shadow
    public abstract void shadow$setInvisible(boolean var1);

    @Shadow
    protected abstract int shadow$getFireImmuneTicks();

    @Shadow
    public abstract EntityType<?> shadow$getType();

    @Shadow
    public abstract void shadow$setMotion(Vec3d var1);

    @Shadow
    public abstract Vec3d shadow$getMotion();

    @Shadow
    public abstract boolean shadow$isInWater();

    @Shadow
    public abstract boolean shadow$isPassenger();

    @Shadow
    public abstract void shadow$setPositionAndUpdate(double var1, double var3, double var5);

    @Shadow
    public abstract int shadow$getMaxAir();

    @Shadow
    protected abstract void shadow$applyEnchantments(LivingEntity var1, net.minecraft.entity.Entity var2);

    @Shadow
    public abstract CommandSource shadow$getCommandSource();

    @Shadow
    public abstract World shadow$getEntityWorld();

    @Shadow
    public abstract Vec3d shadow$getPositionVector();

    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    public abstract void shadow$setWorld(World var1);

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$entityDropItem(ItemStack var1, float var2);

    @Shadow
    protected abstract void shadow$setRotation(float var1, float var2);

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity shadow$getRidingEntity();

    @Shadow
    public abstract boolean shadow$isInvulnerableTo(DamageSource var1);

    @Shadow
    public abstract AxisAlignedBB shadow$getBoundingBox();

    @Shadow
    public abstract boolean shadow$isSprinting();

    @Shadow
    public abstract boolean shadow$isOnSameTeam(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract double shadow$getDistanceSq(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract SoundCategory shadow$getSoundCategory();

    @Shadow
    @Nullable
    public abstract Team shadow$getTeam();

    @Shadow
    public abstract void shadow$extinguish();

    @Shadow
    protected abstract void shadow$setFlag(int var1, boolean var2);

    @Shadow
    public abstract void shadow$setLocationAndAngles(double var1, double var3, double var5, float var7, float var8);

    @Override
    public boolean bridge$isConstructing() {
        return this.impl$isConstructing;
    }

    @Override
    public void bridge$fireConstructors() {
        this.impl$isConstructing = false;
    }

    @Override
    public boolean bridge$setLocation(ServerLocation location) {
        if (this.removed || ((WorldBridge)location.getWorld()).bridge$isFake()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Event event2;
            frame.pushCause(SpongeCommon.getActivePlugin());
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            Vec3d originalPosition = this.shadow$getPositionVector();
            net.minecraft.world.server.ServerWorld destinationWorld = (net.minecraft.world.server.ServerWorld)location.getWorld();
            if (this.shadow$getEntityWorld() != destinationWorld) {
                event2 = SpongeEventFactory.createChangeEntityWorldEventPre(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$getEntityWorld(), (ServerWorld)location.getWorld(), (ServerWorld)location.getWorld());
                if (SpongeCommon.postEvent(event2) && ((WorldBridge)((Object)event2.getDestinationWorld())).bridge$isFake()) {
                    boolean bl = false;
                    return bl;
                }
                ChangeEntityWorldEvent.Reposition repositionEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$getEntityWorld(), VecHelper.toVector3d(this.shadow$getPositionVector()), location.getPosition(), event2.getOriginalDestinationWorld(), location.getPosition(), event2.getDestinationWorld());
                if (SpongeCommon.postEvent(repositionEvent)) {
                    boolean bl = false;
                    return bl;
                }
                destinationWorld = (net.minecraft.world.server.ServerWorld)event2.getDestinationWorld();
                this.shadow$setPosition(repositionEvent.getDestinationPosition().getX(), repositionEvent.getDestinationPosition().getY(), repositionEvent.getDestinationPosition().getZ());
            } else {
                event2 = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), VecHelper.toVector3d(this.shadow$getPositionVector()), location.getPosition(), location.getPosition());
                if (SpongeCommon.postEvent(event2)) {
                    boolean repositionEvent = false;
                    return repositionEvent;
                }
                this.shadow$setPosition(event2.getDestinationPosition().getX(), event2.getDestinationPosition().getY(), event2.getDestinationPosition().getZ());
            }
            if (!destinationWorld.getChunkProvider().chunkExists((int)this.shadow$getPosX() >> 4, (int)this.shadow$getPosZ() >> 4)) {
                this.shadow$setPosition(originalPosition.x, originalPosition.y, originalPosition.z);
                boolean event2 = false;
                return event2;
            }
            ((net.minecraft.entity.Entity)this).detach();
            net.minecraft.world.server.ServerWorld originalWorld = (net.minecraft.world.server.ServerWorld)this.shadow$getEntityWorld();
            ((PlatformServerWorldBridge)this.shadow$getEntityWorld()).bridge$removeEntity((net.minecraft.entity.Entity)this, true);
            this.bridge$revive();
            this.shadow$setWorld((World)destinationWorld);
            destinationWorld.addFromAnotherDimension((net.minecraft.entity.Entity)this);
            originalWorld.resetUpdateEntityTick();
            destinationWorld.resetUpdateEntityTick();
            ChunkPos chunkPos = new ChunkPos((int)this.shadow$getPosX() >> 4, (int)this.shadow$getPosZ() >> 4);
            destinationWorld.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkPos, 1, (Object)((net.minecraft.entity.Entity)this).getEntityId());
        }
        return true;
    }

    @Override
    public boolean bridge$dismountRidingEntity(DismountType type) {
        net.minecraft.entity.Entity tempEntity;
        if (!this.world.isRemote && (ShouldFire.RIDE_ENTITY_EVENT_DISMOUNT || ShouldFire.RIDE_ENTITY_EVENT)) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.DISMOUNT_TYPE, type);
                if (SpongeCommon.postEvent(SpongeEventFactory.createRideEntityEventDismount(frame.getCurrentCause(), (Entity)this.shadow$getRidingEntity()))) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        if ((tempEntity = this.shadow$getRidingEntity()) != null) {
            this.ridingEntity = null;
            ((EntityAccessor)tempEntity).accessor$removePassenger((net.minecraft.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean bridge$removePassengers(DismountType type) {
        boolean dismount = false;
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            dismount = ((EntityBridge)this.passengers.get(i)).bridge$dismountRidingEntity(type) || dismount;
        }
        return dismount;
    }

    @Override
    public boolean bridge$getIsInvulnerable() {
        return this.impl$invulnerable;
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.shadow$isInvisible();
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        this.shadow$setInvisible(invisible);
        if (invisible) {
            CompoundNBT spongeData = this.data$getSpongeData();
            spongeData.putBoolean("IsInvisible", true);
        } else if (this.data$hasSpongeData()) {
            this.data$getSpongeData().remove("IsInvisible");
        }
    }

    @Override
    public boolean bridge$isVanished() {
        return this.impl$isVanished;
    }

    @Override
    public void bridge$setVanished(boolean vanished) {
        this.impl$isVanished = vanished;
        this.impl$pendingVisibilityUpdate = true;
        this.impl$visibilityTicks = 20;
        if (vanished) {
            CompoundNBT spongeData = this.data$getSpongeData();
            spongeData.putBoolean("IsVanished", true);
        } else if (this.data$hasSpongeData()) {
            CompoundNBT spongeData = this.data$getSpongeData();
            spongeData.remove("IsVanished");
            spongeData.remove("VanishUnCollideable");
            spongeData.remove("VanishUnTargetable");
        }
    }

    @Override
    public boolean bridge$isUncollideable() {
        return this.impl$collision;
    }

    @Override
    public void bridge$setUncollideable(boolean prevents) {
        this.impl$collision = prevents;
    }

    @Override
    public boolean bridge$isUntargetable() {
        return this.impl$untargetable;
    }

    @Override
    public void bridge$setUntargetable(boolean untargetable) {
        this.impl$untargetable = untargetable;
    }

    @Override
    public Timing bridge$getTimingsHandler() {
        return ((EntityTypeBridge)this.shadow$getType()).bridge$getTimings();
    }

    @Override
    public void bridge$setInvulnerable(boolean value) {
        this.impl$invulnerable = value;
    }

    @Override
    public void bridge$setTransient(boolean value) {
        this.impl$transient = value;
    }

    @Override
    public void bridge$setFireImmuneTicks(int ticks) {
        this.impl$hasCustomFireImmuneTicks = true;
        this.impl$fireImmuneTicks = (short)ticks;
    }

    @Override
    public CommandSource bridge$getCommandSource(Cause cause) {
        return this.shadow$getCommandSource();
    }

    @Override
    public void bridge$setTransform(Transform transform) {
        this.shadow$setPosition(transform.getPosition().getX(), transform.getPosition().getY(), transform.getPosition().getZ());
        this.shadow$setRotation((float)transform.getYaw(), (float)transform.getPitch());
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.impl$customDataCompound;
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.impl$customDataCompound = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ENTITY;
    }

    @Overwrite
    public final void teleportKeepLoaded(double x, double y, double z) {
        if (this.world instanceof net.minecraft.world.server.ServerWorld) {
            PhaseTracker server = PhaseTracker.SERVER;
            boolean hasMovementContext = true;
            if (!server.getCurrentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                hasMovementContext = false;
                server.pushCause(SpongeCommon.getActivePlugin());
                server.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            }
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(server.getCurrentCause(), (Entity)((Object)this), VecHelper.toVector3d(this.shadow$getPositionVector()), new Vector3d(x, y, z), new Vector3d(x, y, z));
            if (!hasMovementContext) {
                server.popCause();
                server.removeContext(EventContextKeys.MOVEMENT_TYPE);
            }
            if (SpongeCommon.postEvent(event)) {
                return;
            }
            Vector3d destinationPosition = event.getDestinationPosition();
            ChunkPos chunkpos = new ChunkPos(new BlockPos(destinationPosition.getX(), destinationPosition.getY(), destinationPosition.getZ()));
            ((net.minecraft.world.server.ServerWorld)this.world).getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 0, (Object)this.shadow$getEntityId());
            this.world.getChunk(chunkpos.x, chunkpos.z);
            this.shadow$setPositionAndUpdate(destinationPosition.getX(), destinationPosition.getY(), destinationPosition.getZ());
        }
    }

    @Nullable
    @Overwrite
    public net.minecraft.entity.Entity changeDimension(DimensionType destination) {
        if (this.shadow$getEntityWorld().isRemote || this.removed) {
            return null;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PORTAL);
            DimensionChangeResult<net.minecraft.entity.Entity> result = EntityUtil.invokePortalTo((net.minecraft.entity.Entity)this, (PortalType)new WrappedITeleporterPortalType((PlatformITeleporterBridge)this.shadow$getServer().getWorld(destination).getDefaultTeleporter(), null), destination);
            if (!result.isSuccess() && result.shouldRemove()) {
                net.minecraft.entity.Entity entity = null;
                return entity;
            }
            net.minecraft.entity.Entity entity = result.getEntity();
            return entity;
        }
    }

    @Inject(method={"startRiding(Lnet/minecraft/entity/Entity;Z)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;ridingEntity:Lnet/minecraft/entity/Entity;", ordinal=0)}, cancellable=true)
    private void impl$onStartRiding(net.minecraft.entity.Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (!this.world.isRemote && (ShouldFire.RIDE_ENTITY_EVENT_MOUNT || ShouldFire.RIDE_ENTITY_EVENT)) {
            PhaseTracker.getCauseStackManager().pushCause(this);
            if (SpongeCommon.postEvent(SpongeEventFactory.createRideEntityEventMount(PhaseTracker.getCauseStackManager().getCurrentCause(), (Entity)vehicle))) {
                ci.cancel();
            }
            PhaseTracker.getCauseStackManager().popCause();
        }
    }

    @Overwrite
    public void stopRiding() {
        if (this.shadow$getRidingEntity() != null) {
            if (this.shadow$getRidingEntity().removed) {
                this.bridge$dismountRidingEntity(DismountTypes.DEATH.get());
            } else {
                this.bridge$dismountRidingEntity(DismountTypes.PLAYER.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"setOnFireFromLava"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean impl$createLavaBlockDamageSource(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.world.isRemote) {
            return entity.attackEntityFrom(source, damage);
        }
        try {
            AxisAlignedBB bb = this.shadow$getBoundingBox().grow((double)-0.1f, (double)-0.4f, (double)-0.1f);
            ServerLocation location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.getMaterial() == Material.LAVA);
            MinecraftBlockDamageSource lava = new MinecraftBlockDamageSource("lava", location);
            ((DamageSourceBridge)((Object)lava)).bridge$setLava();
            boolean bl = entity.attackEntityFrom(DamageSource.LAVA, damage);
            return bl;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setLava();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealFireDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean impl$spongeRedirectForFireDamage(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.world.isRemote) {
            return entity.attackEntityFrom(source, damage);
        }
        try {
            AxisAlignedBB bb = this.shadow$getBoundingBox().shrink(-0.001);
            ServerLocation location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.getBlock() == Blocks.FIRE || block.getBlock() == Blocks.LAVA);
            MinecraftBlockDamageSource fire = new MinecraftBlockDamageSource("inFire", location);
            ((DamageSourceBridge)((Object)fire)).bridge$setFireSource();
            boolean bl = entity.attackEntityFrom(DamageSource.IN_FIRE, damage);
            return bl;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setFireSource();
        }
    }

    @Redirect(method={"getEntityString"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityType;isSerializable()Z"))
    private boolean impl$respectTransientFlag(EntityType entityType) {
        if (!entityType.isSerializable()) {
            return false;
        }
        return !this.impl$transient;
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$getFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"writeWithoutTypeId"}, at={@At(value="RETURN")})
    private void impl$WriteSpongeDataToCompound(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> ci) {
        CompoundNBT forgeCompound;
        if (this.data$hasSpongeData() && (forgeCompound = compound.getCompound("ForgeData")) != this.data$getForgeData()) {
            if (forgeCompound.isEmpty()) {
                compound.put("ForgeData", (INBT)forgeCompound);
            }
            forgeCompound.put("SpongeData", (INBT)this.data$getSpongeData());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void impl$ReadSpongeDataFromCompound(CompoundNBT compound, CallbackInfo ci) {
        this.data$setCompound(compound);
        if (this.data$hasSpongeData()) {
            CustomDataHolderBridge.syncTagToCustom(this);
            this.data$setCompound(null);
            CustomDataHolderBridge.syncCustomToTag(this);
        } else {
            this.data$setCompound(null);
        }
    }

    protected void impl$readFromSpongeCompound(CompoundNBT compound) {
        CustomDataHolderBridge.syncTagToCustom(this);
        if (this instanceof GrieferBridge && ((GrieferBridge)((Object)this)).bridge$isGriefer() && compound.contains("CanGrief")) {
            ((GrieferBridge)((Object)this)).bridge$setCanGrief(compound.getBoolean("CanGrief"));
        }
        if (compound.contains("IsVanished", 1)) {
            this.bridge$setVanished(compound.getBoolean("IsVanished"));
            this.bridge$setUncollideable(compound.getBoolean("VanishUnCollideable"));
            this.bridge$setUntargetable(compound.getBoolean("VanishUnTargetable"));
        }
        if (compound.contains("IsInvisible", 1)) {
            this.bridge$setInvisible(compound.getBoolean("IsInvisible"));
        }
        CustomDataHolderBridge.syncCustomToTag(this);
    }

    protected void impl$writeToSpongeCompound(CompoundNBT compound) {
        CustomDataHolderBridge.syncCustomToTag(this);
        if (this instanceof GrieferBridge && ((GrieferBridge)((Object)this)).bridge$isGriefer() && ((GrieferBridge)((Object)this)).bridge$canGrief()) {
            compound.putBoolean("CanGrief", true);
        }
        if (this.bridge$isVanished()) {
            compound.putBoolean("IsVanished", true);
            compound.putBoolean("VanishUnCollideable", this.bridge$isUncollideable());
            compound.putBoolean("VanishUnTargetable", this.bridge$isUntargetable());
        }
        if (this.shadow$isInvisible()) {
            compound.putBoolean("IsInvisible", true);
        }
    }

    protected boolean impl$canCallIgniteEntityEvent() {
        return false;
    }
}

