/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.item.EnderCrystalEntityBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={EnderCrystalEntity.class})
public abstract class EnderCrystalEntityMixin
extends EntityMixin
implements ExplosiveBridge,
EnderCrystalEntityBridge {
    private int impl$explosionStrength = 6;

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionStrength);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionStrength = radius == null ? 6 : radius;
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion impl$throwEventWithEntity(World world, Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, Explosion.Mode modeIn, DamageSource source, float damage) {
        return this.bridge$throwExplosionEventAndExplode(world, entityIn, xIn, yIn, zIn, modeIn.compareTo((Enum)Explosion.Mode.DESTROY) <= 0, source);
    }

    @Override
    @Nullable
    public net.minecraft.world.Explosion bridge$throwExplosionEventAndExplode(World world, @Nullable Entity nil, double x, double y, double z, boolean smoking, @Nullable DamageSource source) {
        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
        try (CauseStackManager.StackFrame frame = causeStackManager.pushCauseFrame();){
            frame.pushCause(this);
            if (source != null) {
                frame.pushCause(source);
            }
            net.minecraft.world.Explosion explosion = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)world, x, y, z)).radius(this.impl$explosionStrength).shouldPlaySmoke(smoking)).orElse(null);
            return explosion;
        }
    }
}

