/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EyeOfEnderEntity;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.entity.projectile.EyeOfEnder;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EyeOfEnderEntity.class})
public abstract class EyeOfEnderEntityMixin
extends EntityMixin
implements LocationTargetingBridge {
    @Shadow
    private double targetX;
    @Shadow
    private double targetY;
    @Shadow
    private double targetZ;
    private ProjectileSource projectileSource = UnknownProjectileSource.UNKNOWN;

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (EyeOfEnder)((Object)this));
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.projectileSource, (Entity)null);
    }

    @Override
    public Vector3d bridge$getTargetedPosition() {
        return new Vector3d(this.targetX, this.targetY, this.targetZ);
    }

    @Override
    public void bridge$setTargetedPosition(Vector3d vec) {
        this.targetX = vec.getX();
        this.targetY = vec.getY();
        this.targetZ = vec.getZ();
    }
}

