/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={FireworkRocketEntity.class})
public abstract class FireworkRocketEntityMixin
extends EntityMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int fireworkAge;
    @Shadow
    private int lifetime;
    private ProjectileSource impl$projectileSource = UnknownProjectileSource.UNKNOWN;
    private int impl$explosionRadius = 0;

    @Shadow
    protected abstract void func_213893_k();

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (FireworkRocket)((Object)this));
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.impl$projectileSource, (Entity)null);
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.lifetime;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.lifetime = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.lifetime - this.fireworkAge;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.fireworkAge = 0;
        this.lifetime = fuseTicks;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius == null ? 0 : radius;
    }

    @Redirect(method={"func_213893_k()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V"))
    private void impl$useSpongeExplosion(World world, Entity self, byte state) {
        if (this.world.isRemote) {
            world.setEntityState(self, state);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
            SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().sourceExplosive((FireworkRocket)((Object)this)).location(((FireworkRocket)((Object)this)).getServerLocation()).radius(this.impl$explosionRadius)).ifPresent(explosion -> world.setEntityState(self, state));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void impl$postPrimeEvent(CallbackInfo ci) {
        if (this.fireworkAge == 1 && !this.world.isRemote) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
                this.bridge$postPrime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealExplosionDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean impl$useEntitySource(LivingEntity entityLivingBase, DamageSource source, float amount) {
        try {
            DamageSource fireworks = new EntityDamageSource(DamageSource.FIREWORKS.damageType, (Entity)this).setExplosion();
            ((DamageSourceBridge)fireworks).bridge$setFireworksSource();
            boolean bl = entityLivingBase.attackEntityFrom(DamageSource.FIREWORKS, amount);
            return bl;
        }
        finally {
            ((DamageSourceBridge)source).bridge$setFireworksSource();
        }
    }

    @Inject(method={"func_213892_a"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onImpact(RayTraceResult rayTraceResult, CallbackInfo ci) {
        if (((WorldBridge)this.world).bridge$isFake() || rayTraceResult.getType() == RayTraceResult.Type.MISS) {
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((Entity)this, ((FireworkRocket)((Object)this)).get(Keys.SHOOTER).orElse(null), rayTraceResult)) {
            this.shadow$remove();
            ci.cancel();
        }
    }
}

