/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.item.HangingEntityMixin;

@Mixin(value={ItemFrameEntity.class})
public abstract class ItemFrameEntityMixin
extends HangingEntityMixin {
    @Shadow
    public abstract void shadow$setDisplayedItem(@Nullable ItemStack var1);

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemFrameEntity;dropItemOrSelf(Lnet/minecraft/entity/Entity;Z)V")}, cancellable=true)
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), (ItemFrame)((Object)this), new ArrayList(), 0.0f, amount);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"removeItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;setItemFrame(Lnet/minecraft/entity/item/ItemFrameEntity;)V", shift=At.Shift.AFTER)})
    private void impl$postOnSetItemFrame(CallbackInfo ci) {
        this.shadow$setDisplayedItem(ItemStack.EMPTY);
    }
}

