/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.monster;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(targets={"net/minecraft/entity/monster/EndermanEntity$PlaceBlockGoal"})
public abstract class EndermanEntity_PlaceBlockGoalMixin
extends Goal {
    @Shadow
    @Final
    private EndermanEntity enderman;

    @Redirect(method={"shouldExecute()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/monster/EndermanEntity;getHeldBlockState()Lnet/minecraft/block/BlockState;"))
    @Nullable
    private BlockState impl$onCanGrief(EndermanEntity endermanEntity) {
        BlockState heldBlockState = endermanEntity.getHeldBlockState();
        return ((GrieferBridge)this.enderman).bridge$canGrief() ? heldBlockState : null;
    }

    @Redirect(method={"func_220836_a(Lnet/minecraft/world/IWorldReader;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;isCollisionShapeOpaque(Lnet/minecraft/world/IBlockReader;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$onPlaceBlockCancel(BlockState blockState, IBlockReader blockReaderIn, BlockPos blockPosIn) {
        if (blockState.isCollisionShapeOpaque(blockReaderIn, blockPosIn)) {
            if (ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
                ServerLocation location = ServerLocation.of((ServerWorld)blockReaderIn, blockPosIn.getX(), blockPosIn.getY(), blockPosIn.getZ());
                ArrayList<ServerLocation> list = new ArrayList<ServerLocation>(1);
                list.add(location);
                Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
                ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(cause, list, (ServerWorld)this.enderman.getEntityWorld());
                return !SpongeCommon.postEvent(event);
            }
            return true;
        }
        return false;
    }
}

