/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.monster;

import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.Direction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.entity.monster.ShulkerEntityBridge;
import org.spongepowered.common.mixin.core.entity.MobEntityMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={ShulkerEntity.class})
public abstract class ShulkerEntityMixin
extends MobEntityMixin
implements ShulkerEntityBridge {
    @Shadow
    @Final
    protected static DataParameter<Byte> COLOR;
    @Shadow
    @Final
    protected static DataParameter<Direction> ATTACHED_FACE;

    @Override
    public @Nullable DyeColor bridge$getColor() {
        byte color = (Byte)this.dataManager.get(COLOR);
        if (color > 15) {
            return null;
        }
        return (DyeColor)net.minecraft.item.DyeColor.byId((int)color);
    }

    @Override
    public void bridge$setColor(@Nullable DyeColor color) {
        int value = color == null ? 16 : ((net.minecraft.item.DyeColor)color).getId();
        this.dataManager.set(COLOR, (Object)((byte)value));
    }

    @Override
    public org.spongepowered.api.util.Direction bridge$getDirection() {
        return Constants.DirectionFunctions.getFor((Direction)this.dataManager.get(ATTACHED_FACE));
    }

    @Override
    public void bridge$setDirection(org.spongepowered.api.util.Direction direction) {
        this.dataManager.set(ATTACHED_FACE, (Object)Constants.DirectionFunctions.getFor(direction));
    }
}

