/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.projectile.FireballEntityBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.projectile.DamagingProjectileEntityMixin;

@Mixin(value={FireballEntity.class})
public abstract class FireballEntityMixin
extends DamagingProjectileEntityMixin
implements FireballEntityBridge,
ExplosiveBridge {
    @Shadow
    public int explosionPower;

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZLnet/minecraft/world/Explosion$Mode;)Lnet/minecraft/world/Explosion;"))
    @Nullable
    public net.minecraft.world.Explosion impl$throwExplosionEventAndExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        return this.bridge$throwExplosionEventAndExplode(worldObj, nil, x, y, z, strength, flaming, mode);
    }

    @Override
    public net.minecraft.world.Explosion bridge$throwExplosionEventAndExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Explosion.Mode mode) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$canGrief();
        ProjectileSource shooter = (ProjectileSource)((Projectile)((Object)this)).shooter().get();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, shooter);
            frame.pushCause(shooter);
            Optional<net.minecraft.world.Explosion> ex = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(ServerLocation.of((ServerWorld)worldObj, x, y, z)).sourceExplosive((ExplosiveFireball)((Object)this)).radius(strength).canCauseFire(flaming && griefer).shouldPlaySmoke(mode != Explosion.Mode.NONE && griefer).shouldBreakBlocks(mode != Explosion.Mode.NONE && griefer));
            net.minecraft.world.Explosion explosion = ex.orElse(null);
            return explosion;
        }
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.explosionPower);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.explosionPower = radius == null ? 1 : radius;
    }
}

