/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={FireworkRocketItem.class})
public abstract class ItemFireworkMixin {
    @Inject(method={"onItemRightClick"}, at={@At(value="NEW", target="net/minecraft/entity/item/FireworkRocketEntity")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$ThrowPreBeforeSpawning(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack stack) {
        if (this.spongeImpl$ThrowConstructPreEvent(worldIn, playerIn, stack)) {
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)stack));
        }
    }

    @Inject(method={"onItemUse"}, at={@At(value="NEW", target="net/minecraft/entity/item/FireworkRocketEntity")}, cancellable=true)
    private void spongeImpl$ThrowPrimeEventsIfCancelled(ItemUseContext context, CallbackInfoReturnable<ActionResultType> cir) {
        if (this.spongeImpl$ThrowConstructPreEvent(context.getWorld(), context.getPlayer(), context.getItem())) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    private boolean spongeImpl$ThrowConstructPreEvent(World world, PlayerEntity player, ItemStack usedItem) {
        if (ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE && !((WorldBridge)world).bridge$isFake()) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), ServerLocation.of((ServerWorld)world, player.getPosX(), player.getPosY(), player.getPosZ()), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.FIREWORK_ROCKET.get());
                boolean bl = SpongeCommon.postEvent(event);
                return bl;
            }
        }
        return false;
    }

    @Inject(method={"onItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$InjectPrimeEventAndCancel(ItemUseContext context, CallbackInfoReturnable<ActionResultType> cir, ItemStack usedItem, Vec3d vec3d, FireworkRocketEntity rocket) {
        if (this.spongeImpl$ThrowPrimeEventAndGetCancel(context.getWorld(), context.getPlayer(), rocket, usedItem)) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    @Inject(method={"onItemRightClick(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void spongeImpl$InjectPrimeEventAndCancel(World worldIn, PlayerEntity player, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir, ItemStack usedItem, FireworkRocketEntity rocket) {
        if (this.spongeImpl$ThrowPrimeEventAndGetCancel(worldIn, player, rocket, usedItem)) {
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)usedItem));
        }
    }

    private boolean spongeImpl$ThrowPrimeEventAndGetCancel(World world, PlayerEntity player, FireworkRocketEntity rocket, ItemStack usedItem) {
        if (((WorldBridge)world).bridge$isFake()) {
            return false;
        }
        ((FireworkRocket)rocket).offer(Keys.SHOOTER, (Player)player);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                if (!((FusedExplosiveBridge)rocket).bridge$shouldPrime()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

