/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.datasync;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import org.apache.commons.lang3.ObjectUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.network.datasync.DataParameterBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={EntityDataManager.class})
public abstract class EntityDataManagerMixin {
    @Shadow
    @Final
    @Mutable
    private Map<Integer, EntityDataManager.DataEntry<?>> entries = new Int2ObjectOpenHashMap();
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    private boolean dirty;

    @Shadow
    protected abstract <T> EntityDataManager.DataEntry<T> getEntry(DataParameter<T> var1);

    @Overwrite
    public <T> void set(DataParameter<T> key, T value) {
        EntityDataManager.DataEntry<T> dataentry = this.getEntry(key);
        Object currentValue = dataentry.getValue();
        T incomingValue = value;
        if (ObjectUtils.notEqual(value, (Object)currentValue)) {
            Optional<DataTransactionResult> optional;
            Optional converter;
            if (this.entity != null && this.entity.world != null && !this.entity.world.isRemote && !((EntityBridge)this.entity).bridge$isConstructing() && (converter = ((DataParameterBridge)key).bridge$getDataConverter()).isPresent() && (optional = converter.get().createTransaction(this.entity, currentValue, value)).isPresent()) {
                DataTransactionResult transaction = optional.get();
                ChangeDataHolderEvent.ValueChange event = SpongeEventFactory.createChangeDataHolderEventValueChange(PhaseTracker.getCauseStackManager().getCurrentCause(), transaction, (DataHolder.Mutable)this.entity);
                Sponge.getEventManager().post(event);
                if (event.isCancelled()) {
                    return;
                }
                try {
                    value = converter.get().getValueFromEvent(currentValue, event.getEndResult().getSuccessfulData());
                }
                catch (Exception e) {
                    value = incomingValue;
                }
            }
            dataentry.setValue(value);
            this.entity.notifyDataManagerChange(key);
            dataentry.setDirty(true);
            this.dirty = true;
        }
    }
}

