/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.login;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.NetworkManagerHolderBridge;
import org.spongepowered.common.bridge.network.ServerLoginNetHandlerBridge;

@Mixin(value={ServerLoginNetHandler.class})
public abstract class ServerLoginNetHandlerMixin
implements ServerLoginNetHandlerBridge,
NetworkManagerHolderBridge {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    public NetworkManager networkManager;
    @Shadow
    private GameProfile loginGameProfile;

    @Shadow
    public abstract String getConnectionInfo();

    @Shadow
    protected abstract GameProfile getOfflineProfile(GameProfile var1);

    @Override
    public NetworkManager bridge$getNetworkManager() {
        return this.networkManager;
    }

    @Redirect(method={"tryAcceptPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$ignoreConnections(PlayerList confMgr, SocketAddress address, GameProfile profile) {
        return null;
    }

    private void impl$closeConnection(ITextComponent reason) {
        try {
            LOGGER.info("Disconnecting " + this.getConnectionInfo() + ": " + reason.getUnformattedComponentText());
            this.networkManager.sendPacket((IPacket)new SDisconnectPacket(reason));
            this.networkManager.closeChannel(reason);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private void impl$disconnectClient(Component disconnectMessage) {
        ITextComponent reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.impl$closeConnection(reason);
    }

    @Override
    public boolean bridge$fireAuthEvent() {
        TextComponent disconnectMessage = Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (Component)disconnectMessage, (Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.getMessage());
        }
        return event.isCancelled();
    }

    @Inject(method={"processLoginStart"}, at={@At(value="FIELD", target="Lnet/minecraft/network/login/ServerLoginNetHandler;currentLoginState:Lnet/minecraft/network/login/ServerLoginNetHandler$State;", opcode=181, ordinal=1)}, cancellable=true)
    private void impl$fireAuthEventOffline(CallbackInfo ci) {
        if (!this.loginGameProfile.isComplete()) {
            this.loginGameProfile = this.getOfflineProfile(this.loginGameProfile);
        }
        if (this.bridge$fireAuthEvent()) {
            ci.cancel();
        }
    }
}

