/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.rcon;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.rcon.ClientThread;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.network.rcon.RConThread;
import net.minecraft.network.rcon.RConUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.rcon.RconConnectionEvent;
import org.spongepowered.api.network.RconConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.network.rcon.ClientThreadBridge;
import org.spongepowered.common.bridge.network.rcon.RConConsoleSourceBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={ClientThread.class})
public abstract class ClientThreadMixin
extends RConThread
implements ClientThreadBridge {
    private static final Logger LOGGER = LogManager.getLogger();
    @Shadow
    private boolean loggedIn;
    @Shadow
    private Socket clientSocket;
    @Shadow
    @Final
    @Mutable
    private String rconPassword;
    @Shadow
    @Final
    @Mutable
    private byte[] buffer;
    private RConConsoleSource impl$source;

    @Shadow
    private void sendMultipacketResponse(int p_72655_1_, String p_72655_2_) throws IOException {
    }

    @Shadow
    private void sendResponse(int p_72654_1_, int p_72654_2_, String message) throws IOException {
    }

    @Shadow
    private void closeSocket() {
    }

    @Shadow
    private void sendLoginFailedResponse() throws IOException {
    }

    protected ClientThreadMixin(IServer p_i45300_1_, String p_i45300_2_) {
        super(p_i45300_1_, p_i45300_2_);
    }

    @Inject(method={"closeSocket"}, at={@At(value="HEAD")})
    private void impl$rconLogoutCallback(CallbackInfo ci) {
        if (this.loggedIn) {
            SpongeCommon.getServerScheduler().execute(() -> {
                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                causeStackManager.pushCause(this);
                causeStackManager.pushCause(this.impl$source);
                RconConnectionEvent.Disconnect event = SpongeEventFactory.createRconConnectionEventDisconnect(causeStackManager.getCurrentCause(), (RconConnection)this.impl$source);
                SpongeCommon.postEvent(event);
                causeStackManager.popCauses(2);
                return event;
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void run() {
        RconConnectionEvent.Connect connectEvent;
        this.impl$source = new RConConsoleSource(SpongeCommon.getServer());
        ((RConConsoleSourceBridge)this.impl$source).bridge$setConnection((ClientThread)this);
        try {
            connectEvent = SpongeCommon.getServerScheduler().execute(() -> {
                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                causeStackManager.pushCause(this);
                causeStackManager.pushCause(this.impl$source);
                RconConnectionEvent.Connect event = SpongeEventFactory.createRconConnectionEventConnect(causeStackManager.getCurrentCause(), (RconConnection)this.impl$source);
                SpongeCommon.postEvent(event);
                causeStackManager.popCauses(2);
                return event;
            }).get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            this.closeSocket();
            return;
        }
        if (connectEvent.isCancelled()) {
            this.closeSocket();
            return;
        }
        try {
            BufferedInputStream bufferedinputstream;
            int i;
            block11: while (this.running && (i = (bufferedinputstream = new BufferedInputStream(this.clientSocket.getInputStream())).read(this.buffer, 0, this.buffer.length)) != -1) {
                if (10 > i) continue;
                int j = 0;
                int k = RConUtils.getBytesAsLEInt((byte[])this.buffer, (int)0, (int)i);
                if (k == i - 4) {
                    int l = RConUtils.getBytesAsLEInt((byte[])this.buffer, (int)(j += 4), (int)i);
                    int i1 = RConUtils.getRemainingBytesAsLEInt((byte[])this.buffer, (int)(j += 4));
                    j += 4;
                    switch (i1) {
                        case 2: {
                            if (this.loggedIn) {
                                String command = RConUtils.getBytesAsString((byte[])this.buffer, (int)j, (int)i);
                                try {
                                    SpongeCommon.getServerScheduler().execute(() -> {
                                        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                                        causeStackManager.pushCause(this);
                                        SpongeCommon.getServer().getCommandManager().handleCommand(this.impl$source.getCommandSource(), command);
                                        causeStackManager.popCause();
                                    }).get();
                                    String logContents = this.impl$source.getLogContents();
                                    this.impl$source.resetLog();
                                    this.sendMultipacketResponse(l, logContents);
                                    continue block11;
                                }
                                catch (Exception exception) {
                                    this.sendMultipacketResponse(l, "Error executing: " + command + " (" + exception.getMessage() + ")");
                                    continue block11;
                                }
                            }
                            this.sendLoginFailedResponse();
                            continue block11;
                        }
                        case 3: {
                            RconConnectionEvent.Auth event;
                            String password = RConUtils.getBytesAsString((byte[])this.buffer, (int)j, (int)i);
                            if (!password.isEmpty() && password.equals(this.rconPassword) && !(event = SpongeCommon.getServerScheduler().execute(() -> {
                                CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
                                causeStackManager.pushCause(this);
                                causeStackManager.pushCause(this.impl$source);
                                RconConnectionEvent.Auth event1 = SpongeEventFactory.createRconConnectionEventAuth(causeStackManager.getCurrentCause(), (RconConnection)this.impl$source);
                                SpongeCommon.postEvent(event1);
                                causeStackManager.popCauses(2);
                                return event1;
                            }).get()).isCancelled()) {
                                this.loggedIn = true;
                                this.sendResponse(l, 2, "");
                                continue block11;
                            }
                            this.loggedIn = false;
                            this.sendLoginFailedResponse();
                            continue block11;
                        }
                    }
                    this.sendMultipacketResponse(l, String.format("Unknown request %s", Integer.toHexString(i1)));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)e);
        }
        this.closeSocket();
    }

    @Override
    public boolean bridge$getLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public void bridge$setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }
}

