/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.scoreboard.ScorePlayerTeamBridge;

@Mixin(value={ScorePlayerTeam.class})
public abstract class ScorePlayerTeamMixin
implements ScorePlayerTeamBridge {
    @Shadow
    @Final
    @Mutable
    private @Nullable Scoreboard scoreboard;
    @Shadow
    private ITextComponent displayName;
    @Shadow
    private TextFormatting color;
    @Shadow
    private ITextComponent prefix;
    @Shadow
    private ITextComponent suffix;
    private @MonotonicNonNull Component bridge$displayName;
    private @MonotonicNonNull Component bridge$Prefix;
    private @MonotonicNonNull Component bridge$Suffix;
    private @MonotonicNonNull NamedTextColor bridge$Color;

    @Shadow
    public abstract Collection<String> getMembershipCollection();

    private void impl$doTeamUpdate() {
        if (this.scoreboard != null) {
            this.scoreboard.onTeamChanged((ScorePlayerTeam)this);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpDisplayNames(Scoreboard scoreboardIn, String name, CallbackInfo ci) {
        this.bridge$displayName = SpongeAdventure.legacySection(name);
        this.bridge$Prefix = SpongeAdventure.asAdventure(this.prefix);
        this.bridge$Suffix = SpongeAdventure.asAdventure(this.suffix);
        this.bridge$Color = SpongeAdventure.asAdventureNamed(this.color);
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;onTeamChanged(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void impl$nullCheckScoreboard(@Nullable Scoreboard scoreboard, ScorePlayerTeam team) {
        if (scoreboard != null) {
            scoreboard.onTeamChanged(team);
        }
    }

    @Inject(method={"setDisplayName"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;displayName:Lnet/minecraft/util/text/ITextComponent;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForDisplayName(ITextComponent name, CallbackInfo ci) {
        this.bridge$displayName = SpongeAdventure.asAdventure(name);
    }

    @Inject(method={"setPrefix"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;prefix:Lnet/minecraft/util/text/ITextComponent;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForPrefix(ITextComponent prefix, CallbackInfo callbackInfo) {
        this.bridge$Prefix = SpongeAdventure.asAdventure(prefix);
    }

    @Inject(method={"setSuffix"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;suffix:Lnet/minecraft/util/text/ITextComponent;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForSuffix(ITextComponent suffix, CallbackInfo ci) {
        this.bridge$Suffix = SpongeAdventure.asAdventure(suffix);
    }

    @Inject(method={"setColor"}, at={@At(value="RETURN")})
    private void impl$doTeamUpdateForFormat(TextFormatting format, CallbackInfo ci) {
        this.bridge$Color = SpongeAdventure.asAdventureNamed(format);
        this.impl$doTeamUpdate();
    }

    @Override
    public Component bridge$getDisplayName() {
        return this.bridge$displayName;
    }

    @Override
    public void bridge$setDisplayName(Component text) {
        String newText = SpongeAdventure.legacySection(text);
        if (newText.length() > 32) {
            throw new IllegalArgumentException(String.format("Display name is %s characters long! It must be at most 32.", newText.length()));
        }
        this.bridge$displayName = text;
        this.displayName = SpongeAdventure.asVanilla(text);
        this.impl$doTeamUpdate();
    }

    @Override
    public Component bridge$getPrefix() {
        return this.bridge$Prefix;
    }

    @Override
    public void bridge$setPrefix(Component text) {
        String newPrefix = SpongeAdventure.legacySection(text);
        if (newPrefix.length() > 16) {
            throw new IllegalArgumentException(String.format("Prefix is %s characters long! It must be at most 16.", newPrefix.length()));
        }
        this.bridge$Prefix = text;
        this.prefix = SpongeAdventure.asVanilla(text);
        this.impl$doTeamUpdate();
    }

    @Override
    public Component bridge$getSuffix() {
        return this.bridge$Suffix;
    }

    @Override
    public void bridge$setSuffix(Component suffix) {
        String newSuffix = SpongeAdventure.legacySection(suffix);
        if (newSuffix.length() > 16) {
            throw new IllegalArgumentException(String.format("Suffix is %s characters long! It must be at most 16.", newSuffix.length()));
        }
        this.bridge$Suffix = suffix;
        this.suffix = SpongeAdventure.asVanilla(suffix);
        this.impl$doTeamUpdate();
    }

    @Override
    public void bridge$setColor(NamedTextColor color) {
        this.bridge$Color = color;
        this.color = SpongeAdventure.asVanilla(color);
        this.impl$doTeamUpdate();
    }

    @Override
    public Audience bridge$getTeamChannel(ServerPlayerEntity player) {
        return Audience.audience((Iterable)this.getMembershipCollection().stream().map(name -> Sponge.getGame().getServer().getPlayer((String)name)).filter(Optional::isPresent).map(Optional::get).filter(member -> member != player).collect(Collectors.toSet()));
    }

    @Override
    public Audience bridge$getNonTeamChannel() {
        return Audience.audience((Iterable)Sponge.getGame().getServer().getOnlinePlayers().stream().filter(player -> ((ServerPlayerEntity)player).getTeam() != this).collect(Collectors.toSet()));
    }
}

