/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;

@Mixin(value={TileEntity.class})
public abstract class TileEntityMixin
implements TileEntityBridge,
DataCompoundHolder,
TimingBridge {
    @Shadow
    @Final
    private TileEntityType<?> type;
    @Shadow
    @Nullable
    private BlockState cachedBlockState;
    @Shadow
    protected World world;
    @Shadow
    protected BlockPos pos;
    @Nullable
    private Timing impl$timing;
    private CompoundNBT impl$nbt;

    @Shadow
    public abstract BlockPos shadow$getPos();

    @Shadow
    public abstract BlockState shadow$getBlockState();

    @Shadow
    public abstract void shadow$markDirty();

    @Override
    public Timing bridge$getTimingsHandler() {
        if (this.impl$timing == null) {
            this.impl$timing = SpongeTimings.getTileEntityTiming((BlockEntity)((Object)this));
        }
        return this.impl$timing;
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.impl$nbt;
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.impl$nbt = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    @Inject(method={"writeInternal"}, at={@At(value="RETURN")})
    private void impl$writeSpongeData(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> ci) {
        CompoundNBT forgeCompound;
        if (this.data$hasSpongeData() && (forgeCompound = compound.getCompound("ForgeData")) != this.data$getForgeData()) {
            if (forgeCompound.isEmpty()) {
                compound.put("ForgeData", (INBT)forgeCompound);
            }
            forgeCompound.put("SpongeData", (INBT)this.data$getSpongeData());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void impl$readSpongeData(CompoundNBT compound, CallbackInfo ci) {
        this.data$setCompound(compound);
        if (this.data$hasSpongeData()) {
            CustomDataHolderBridge.syncTagToCustom(this);
            this.data$setCompound(null);
            CustomDataHolderBridge.syncCustomToTag(this);
        } else {
            this.data$setCompound(null);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tileType", (Object)((BlockEntityType)this.type).getKey()).add("world", (Object)this.world).add("pos", (Object)this.pos).add("blockMetadata", (Object)this.cachedBlockState).toString();
    }

    protected MoreObjects.ToStringHelper getPrettyPrinterStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)((BlockEntityType)this.type).getKey()).add("world", (Object)((ServerWorld)this.world).getKey()).add("pos", (Object)this.pos);
    }

    @Override
    public String bridge$getPrettyPrinterString() {
        return this.getPrettyPrinterStringHelper().toString();
    }
}

