/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util;

import com.google.common.base.MoreObjects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.world.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.registry.provider.DamageSourceToTypeProvider;
import org.spongepowered.common.util.MemoizedSupplier;

@Mixin(value={DamageSource.class})
public abstract class DamageSourceMixin
implements DamageSourceBridge {
    @Shadow
    @Final
    @Mutable
    public static DamageSource LAVA;
    @Shadow
    @Final
    @Mutable
    public static DamageSource IN_FIRE;
    @Shadow
    @Final
    @Mutable
    public static DamageSource LIGHTNING_BOLT;
    @Shadow
    @Final
    @Mutable
    public static DamageSource HOT_FLOOR;
    @Shadow
    @Final
    @Mutable
    public static DamageSource FIREWORKS;
    @Shadow
    @Final
    @Mutable
    public static DamageSource ANVIL;
    @Shadow
    @Final
    @Mutable
    public static DamageSource FALLING_BLOCK;
    @Shadow
    @Final
    @Mutable
    public static DamageSource CACTUS;
    @Shadow
    @Final
    public String damageType;
    Supplier<DamageType> impl$damageType;

    @Shadow
    @Nullable
    public abstract Entity shadow$getTrueSource();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setDamageTypeOnConstruction(String damageType, CallbackInfo ci) {
        this.bridge$resetDamageType();
    }

    @Inject(method={"getDeathMessage"}, cancellable=true, at={@At(value="RETURN")})
    private void beforeGetDeathMessageReturn(LivingEntity livingEntity, CallbackInfoReturnable<ITextComponent> cir) {
        if (((ITextComponent)cir.getReturnValue()).getString().equals("death.attack." + this.damageType)) {
            cir.setReturnValue((Object)new TranslationTextComponent("death.attack.generic", new Object[]{livingEntity.getDisplayName()}));
        }
    }

    @Inject(method={"causeExplosionDamage(Lnet/minecraft/world/Explosion;)Lnet/minecraft/util/DamageSource;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onSetExplosionSource(@Nullable Explosion explosion, CallbackInfoReturnable<DamageSource> cir) {
        Entity entity;
        if (explosion != null && (entity = ((ExplosionAccessor)explosion).accessor$getExploder()) != null && !((WorldBridge)((ExplosionAccessor)explosion).accessor$getWorld()).bridge$isFake() && explosion.getExplosivePlacedBy() == null && entity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity;
            creatorBridge.tracked$getCreatorReference().filter(user -> user instanceof PlayerEntity).map(user -> (PlayerEntity)user).ifPresent(player -> {
                IndirectEntityDamageSource damageSource = new IndirectEntityDamageSource("explosion.player", entity, (Entity)player);
                damageSource.setDifficultyScaled().setExplosion();
                cir.setReturnValue((Object)damageSource);
            });
        }
    }

    @Override
    public DamageType bridge$getDamageType() {
        return this.impl$damageType.get();
    }

    @Override
    public void bridge$resetDamageType() {
        this.impl$damageType = !this.damageType.contains(":") ? MemoizedSupplier.memoize(() -> DamageSourceToTypeProvider.getInstance().getOrCustom(this.damageType).get()) : MemoizedSupplier.memoize(() -> Sponge.getRegistry().getCatalogRegistry().get(DamageType.class, ResourceKey.resolve(this.damageType)).orElseGet(DamageTypes.CUSTOM));
    }

    @Override
    public void bridge$setLava() {
        LAVA = (DamageSource)this;
    }

    @Override
    public void bridge$setFireSource() {
        IN_FIRE = (DamageSource)this;
    }

    @Override
    public void bridge$setLightningSource() {
        LIGHTNING_BOLT = (DamageSource)this;
    }

    @Override
    public void bridge$setHotFloorSource() {
        HOT_FLOOR = (DamageSource)this;
    }

    @Override
    public void bridge$setFireworksSource() {
        FIREWORKS = (DamageSource)this;
    }

    @Override
    public void bridge$setFallingBlockSource() {
        FALLING_BLOCK = (DamageSource)this;
    }

    @Override
    public void bridge$setAnvilSource() {
        ANVIL = (DamageSource)this;
    }

    @Override
    public void bridge$setCactusSource() {
        CACTUS = (DamageSource)this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DamageSource").add("Name", (Object)this.damageType).add("Key", (Object)this.impl$damageType.get().getKey().toString()).toString();
    }
}

