/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.world.TrackedEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.entity.living.human.HumanEntity;

@Mixin(value={TrackedEntity.class})
public abstract class TrackedEntityMixin {
    @Shadow
    @Final
    private Entity trackedEntity;
    @Shadow
    @Final
    @Mutable
    private Consumer<IPacket<?>> packetConsumer;

    @Redirect(method={"sendSpawnPackets"}, at=@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", ordinal=0))
    public void impl$sendHumanSpawnPacket(Consumer<IPacket<?>> consumer, Object spawnPacket) {
        if (!(this.trackedEntity instanceof HumanEntity)) {
            consumer.accept((IPacket)spawnPacket);
            return;
        }
        HumanEntity human = (HumanEntity)this.trackedEntity;
        consumer.accept((IPacket<?>)human.createPlayerListPacket(SPlayerListItemPacket.Action.ADD_PLAYER));
        consumer.accept((IPacket)spawnPacket);
        SPlayerListItemPacket removePacket = human.createPlayerListPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER);
        if (human.canRemoveFromListImmediately()) {
            consumer.accept((IPacket<?>)removePacket);
        } else {
            human.removeFromTabListDelayed(null, removePacket);
        }
    }

    @Inject(method={"sendMetadata"}, at={@At(value="HEAD")})
    public void impl$sendHumanMetadata(CallbackInfo ci) {
        if (!(this.trackedEntity instanceof HumanEntity)) {
            return;
        }
        HumanEntity human = (HumanEntity)this.trackedEntity;
        Stream<IPacket<?>> packets = human.popQueuedPackets(null);
        packets.forEach(this.packetConsumer);
    }
}

