/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.server;

import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.mixin.core.world.BossInfoMixin;

@Mixin(value={ServerBossInfo.class})
public abstract class ServerBossInfoMixin
extends BossInfoMixin
implements BossBar.Listener {
    private static final float EPSILON = 0.01f;
    private float impl$lastSentProgress = 0.0f;
    @Shadow
    @Final
    private Set<ServerPlayerEntity> players;
    @Shadow
    private boolean visible;

    @Shadow
    protected abstract void sendUpdate(SUpdateBossInfoPacket.Operation var1);

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        BossBar oldAdventure = this.impl$adventure;
        super.bridge$setAdventure(adventure);
        if (oldAdventure != adventure) {
            if (oldAdventure != null) {
                oldAdventure.removeListener((BossBar.Listener)this);
            }
            adventure.addListener((BossBar.Listener)this);
            this.name = null;
            this.percent = Float.MIN_VALUE;
            this.color = null;
            this.overlay = null;
        }
    }

    @Override
    public void bridge$replacePlayer(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer) {
        super.bridge$replacePlayer(oldPlayer, newPlayer);
        if (this.players.remove(oldPlayer)) {
            this.players.add(newPlayer);
        }
    }

    @Inject(method={"setDarkenSky"}, at={@At(value="HEAD")})
    private void impl$forceDarkenSkyUpdate(boolean darkenSky, CallbackInfoReturnable<BossInfo> ci) {
        this.darkenSky = !darkenSky;
    }

    @Inject(method={"setPlayEndBossMusic"}, at={@At(value="HEAD")})
    private void forcePlayEndBossMusicUpdate(boolean endBossMusic, CallbackInfoReturnable<BossInfo> ci) {
        this.playEndBossMusic = !endBossMusic;
    }

    @Inject(method={"setCreateFog"}, at={@At(value="HEAD")})
    private void forceCreateFogUpdate(boolean createFog, CallbackInfoReturnable<BossInfo> ci) {
        this.createFog = !createFog;
    }

    @Redirect(method={"setPercent", "setColor", "setOverlay", "setDarkenSky", "setPlayEndBossMusic", "setCreateFog", "setName"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerBossInfo;sendUpdate(Lnet/minecraft/network/play/server/SUpdateBossInfoPacket$Operation;)V"))
    private void redirectUpdatePacket(ServerBossInfo $this, SUpdateBossInfoPacket.Operation op) {
    }

    public void bossBarNameChanged(BossBar bar, Component oldName, Component newName) {
        this.sendUpdate(SUpdateBossInfoPacket.Operation.UPDATE_NAME);
    }

    public void bossBarProgressChanged(BossBar bar, float oldProgress, float newProgress) {
        if (Math.abs(newProgress - this.impl$lastSentProgress) > 0.01f) {
            this.impl$lastSentProgress = newProgress;
            this.sendUpdate(SUpdateBossInfoPacket.Operation.UPDATE_PCT);
        }
    }

    public void bossBarColorChanged(BossBar bar, BossBar.Color oldColor, BossBar.Color newColor) {
        this.sendUpdate(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarOverlayChanged(BossBar bar, BossBar.Overlay oldOverlay, BossBar.Overlay newOverlay) {
        this.sendUpdate(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarFlagsChanged(BossBar bar, Set<BossBar.Flag> flagsAdded, Set<BossBar.Flag> flagsRemoved) {
        this.sendUpdate(SUpdateBossInfoPacket.Operation.UPDATE_PROPERTIES);
    }

    @Inject(method={"addPlayer"}, at={@At(value="TAIL")})
    private void impl$addPlayer(ServerPlayerEntity player, CallbackInfo ci) {
        if (!this.players.isEmpty() && this.visible) {
            SpongeAdventure.registerBossBar((ServerBossInfo)this);
        }
    }

    @Inject(method={"removePlayer"}, at={@At(value="TAIL")})
    private void impl$removePlayer(ServerPlayerEntity player, CallbackInfo ci) {
        if (this.players.isEmpty()) {
            SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
        }
    }

    @Inject(method={"removeAllPlayers"}, at={@At(value="HEAD")})
    private void impl$removeAllPlayers(CallbackInfo ci) {
        SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
    }

    @Inject(method={"setVisible"}, at={@At(value="HEAD")})
    private void impl$setVisible(boolean visible, CallbackInfo ci) {
        if (!this.players.isEmpty()) {
            if (visible) {
                SpongeAdventure.registerBossBar((ServerBossInfo)this);
            } else {
                SpongeAdventure.unregisterBossBar((ServerBossInfo)this);
            }
        }
    }
}

