/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.CollisionModCategory;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={Entity.class}, priority=1002)
public abstract class EntityMixin_EntityCollision
implements CollisionCapabilityBridge {
    private ResourceKey entityCollision$key;
    private int entityCollision$maxCollisions = 8;
    private boolean entityCollision$refreshCache = false;

    @Shadow
    public abstract World shadow$getEntityWorld();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void collisions$InjectActivationInformation(EntityType<?> type, World world, CallbackInfo ci) {
        if (world != null && !((WorldBridge)world).bridge$isFake() && ((WorldInfoBridge)world.getWorldInfo()).bridge$isValid()) {
            if ((Entity)this instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)this;
                net.minecraft.item.ItemStack itemstack = item.getItem();
                if (!itemstack.isEmpty()) {
                    this.entityCollision$key = ((ItemStack)itemstack).getType().getKey();
                }
            } else {
                this.entityCollision$key = ((org.spongepowered.api.entity.Entity)((Object)this)).getType().getKey();
            }
            if (!this.shadow$getEntityWorld().isRemote()) {
                this.collision$initializeCollisionState(this.shadow$getEntityWorld());
            }
        }
    }

    @Override
    public ResourceKey collision$getKey() {
        return this.entityCollision$key;
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.entityCollision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.entityCollision$maxCollisions = max;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        InheritableConfigHandle<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        CollisionModCategory worldCollMod = worldConfigAdapter.getOrCreateValue(s2 -> s2.getEntityCollisionCategory().getModList().get(this.entityCollision$key.getNamespace()), c -> {
            CollisionModCategory globalCollision = new CollisionModCategory(this.entityCollision$key.getNamespace());
            c.getEntityCollisionCategory().getModList().put(this.entityCollision$key.getNamespace(), globalCollision);
            globalCollision.getEntityList().put(this.entityCollision$key.getNamespace(), this.collision$getMaxCollisions());
        }, ((WorldConfig)worldConfigAdapter.get()).getEntityCollisionCategory().autoPopulateData());
        EntityCollisionCategory worldCollCat = ((WorldConfig)worldConfigAdapter.get()).getEntityCollisionCategory();
        this.collision$setMaxCollisions(worldCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        if (worldCollMod != null) {
            if (!worldCollMod.isEnabled()) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.getDefaultMaxCollisions().get("entities");
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            Integer entityMaxCollision = null;
            if ((Entity)this instanceof ItemEntity) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.entityCollision$key.getValue());
            }
            if (entityMaxCollision == null) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.entityCollision$key.getValue());
            }
            if (entityMaxCollision == null && worldCollCat.autoPopulateData()) {
                requiresSave = true;
            } else if (entityMaxCollision != null) {
                this.collision$setMaxCollisions(entityMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.entityCollision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.entityCollision$refreshCache;
    }

    @Override
    public boolean collision$isRunningCollideWithNearby() {
        return false;
    }
}

