/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.MultiBlockCarrier;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.inventory.DefaultSingleBlockCarrier;

@Mixin(value={DoubleSidedInventory.class})
public abstract class DoubleSidedInventoryMixin_Carrier_Inventory_API
implements MultiBlockCarrier {
    @Shadow
    @Final
    private IInventory upperChest;
    @Shadow
    @Final
    private IInventory lowerChest;

    @Override
    public List<ServerLocation> getLocations() {
        ArrayList<ServerLocation> list = new ArrayList<ServerLocation>();
        if (this.upperChest instanceof BlockEntity) {
            list.add(((BlockEntity)this.upperChest).getServerLocation());
        }
        if (this.lowerChest instanceof BlockEntity) {
            list.add(((BlockEntity)this.lowerChest).getServerLocation());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public CarriedInventory<? extends Carrier> getInventory() {
        return (CarriedInventory)((Object)this);
    }

    public ServerLocation getLocation() {
        return this.getLocations().get(0);
    }

    @Override
    public Optional<Inventory> getInventory(ServerLocation at) {
        if (this.getLocations().contains(at)) {
            return Optional.of(this.getInventory());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Inventory> getInventory(ServerLocation at, Direction from) {
        return this.getInventory(at);
    }

    @Override
    public Inventory getInventory(Direction from) {
        return DefaultSingleBlockCarrier.getInventory(from, this);
    }
}

