/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity.player;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={PlayerEntity.class})
public class PlayerEntityMixin_Inventory {
    @Final
    @Shadow
    public PlayerInventory inventory;
    @Shadow
    public Container openContainer;

    @Inject(method={"setItemStackToSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;")})
    private void onSetItemStackToSlot(EquipmentSlotType slotIn, ItemStack stack, CallbackInfo ci) {
        if (((TrackedInventoryBridge)this.inventory).bridge$capturingInventory()) {
            List<SlotTransaction> slotTransactions = ((TrackedInventoryBridge)this.inventory).bridge$getCapturedSlotTransactions();
            if (slotIn == EquipmentSlotType.MAINHAND) {
                ItemStack orig = (ItemStack)this.inventory.mainInventory.get(this.inventory.currentItem);
                Slot slot = ((org.spongepowered.api.item.inventory.entity.PlayerInventory)this.inventory).getPrimary().getHotbar().getSlot(this.inventory.currentItem).get();
                slotTransactions.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            } else if (slotIn == EquipmentSlotType.OFFHAND) {
                ItemStack orig = (ItemStack)this.inventory.offHandInventory.get(0);
                Slot slot = ((org.spongepowered.api.item.inventory.entity.PlayerInventory)this.inventory).getOffhand();
                slotTransactions.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            } else if (slotIn.getSlotType() == EquipmentSlotType.Group.ARMOR) {
                ItemStack orig = (ItemStack)this.inventory.armorInventory.get(slotIn.getIndex());
                Slot slot = ((org.spongepowered.api.item.inventory.entity.PlayerInventory)this.inventory).getEquipment().getSlot(slotIn.getIndex()).get();
                slotTransactions.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(orig), ItemStackUtil.snapshotOf(stack)));
            }
        }
    }

    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;onContainerClosed(Lnet/minecraft/entity/player/PlayerEntity;)V"))
    private void onOnContainerClosed(Container container, PlayerEntity player) {
        if (Sponge.isServerAvailable() && Sponge.isClientAvailable()) {
            container.onContainerClosed(player);
            return;
        }
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            try (BasicPacketContext ctx = ((BasicPacketContext)((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext(PhaseTracker.SERVER).source(serverPlayer)).packetPlayer(serverPlayer)).openContainer(container);){
                ctx.buildAndSwitch();
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.inventory.getItemStack());
                container.onContainerClosed(player);
                SpongeCommonEventFactory.callInteractInventoryCloseEvent(this.openContainer, serverPlayer, cursor, ItemStackSnapshot.empty(), false);
            }
        } else {
            container.onContainerClosed(player);
        }
    }
}

