/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.inventory.container.MenuBridge;
import org.spongepowered.common.bridge.inventory.container.PlayerContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={net.minecraft.inventory.container.Container.class})
public abstract class ContainerMixin_Inventory
implements TrackedContainerBridge,
InventoryAdapter,
TrackedInventoryBridge {
    private boolean impl$shiftCraft = false;
    @Nullable
    private CraftItemEvent.Craft impl$lastCraft = null;
    @Nullable
    private ItemStack impl$previousCursor;
    private boolean impl$firePreview = true;
    private List<SlotTransaction> impl$capturedCraftPreviewTransactions = new ArrayList<SlotTransaction>();
    private boolean impl$captureSuccess = false;
    private boolean impl$dropCancelled = false;
    private ItemStackSnapshot impl$itemStackSnapshot = ItemStackSnapshot.empty();
    @Nullable
    private net.minecraft.inventory.container.Slot impl$lastSlotUsed = null;
    @Final
    @Shadow
    private NonNullList<ItemStack> inventoryItemStacks;
    @Final
    @Shadow
    public List<net.minecraft.inventory.container.Slot> inventorySlots;
    @Final
    @Shadow
    private List<IContainerListener> listeners;
    @Final
    @Shadow
    private List<IntReferenceHolder> trackedIntReferences;

    @Override
    public void bridge$setShiftCrafting(boolean flag) {
        this.impl$shiftCraft = flag;
    }

    @Override
    public boolean bridge$isShiftCrafting() {
        return this.impl$shiftCraft;
    }

    @Override
    public void bridge$setLastCraft(CraftItemEvent.Craft event) {
        this.impl$lastCraft = event;
    }

    @Override
    @Nullable
    public CraftItemEvent.Craft bridge$getLastCraft() {
        return this.impl$lastCraft;
    }

    @Override
    public void bridge$setPreviousCursor(@Nullable ItemStack stack) {
        this.impl$previousCursor = stack;
    }

    @Override
    public ItemStack bridge$getPreviousCursor() {
        return this.impl$previousCursor;
    }

    @Override
    public void bridge$setFirePreview(boolean firePreview) {
        this.impl$firePreview = firePreview;
    }

    @Override
    public boolean bridge$firePreview() {
        return this.impl$firePreview;
    }

    @Override
    public List<SlotTransaction> bridge$getPreviewTransactions() {
        return this.impl$capturedCraftPreviewTransactions;
    }

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Override
    public void bridge$setCapturePossible() {
        this.impl$captureSuccess = true;
    }

    @Shadow
    public abstract net.minecraft.inventory.container.Slot shadow$getSlot(int var1);

    @Inject(method={"putStackInSlot"}, at={@At(value="HEAD")})
    private void impl$addTransaction(int slotId, ItemStack itemstack, CallbackInfo ci) {
        net.minecraft.inventory.container.Slot slot;
        if (this.bridge$capturingInventory() && (slot = this.shadow$getSlot(slotId)) != null) {
            ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(slot.getStack());
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(itemstack);
            Slot adapter = this.inventoryAdapter$getSlot(slotId).get();
            this.bridge$getCapturedSlotTransactions().add(new SlotTransaction(adapter, originalItem, newItem));
        }
    }

    @Nullable
    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=0))
    private ItemEntity impl$RestoreOnDragDrop(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(itemStackIn);
        ItemEntity entityItem = player.dropItem(itemStackIn, unused);
        if (!((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            this.impl$dropCancelled = true;
            PacketPhaseUtil.handleCustomCursor(player, original);
        }
        return entityItem;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;setItemStack(Lnet/minecraft/item/ItemStack;)V", ordinal=1))
    private void impl$ClearOnSlot(PlayerInventory inventoryPlayer, ItemStack itemStackIn) {
        if (!this.impl$dropCancelled || !((PlayerEntityBridge)inventoryPlayer.player).bridge$shouldRestoreInventory()) {
            inventoryPlayer.setItemStack(itemStackIn);
        }
        ((PlayerEntityBridge)inventoryPlayer.player).bridge$shouldRestoreInventory(false);
        this.impl$dropCancelled = false;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=1))
    @Nullable
    private ItemEntity impl$restoreOnDragSplit(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemEntity entityItem = player.dropItem(itemStackIn, unused);
        if (!((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            ItemStack original;
            if (player.inventory.getItemStack().isEmpty()) {
                original = itemStackIn;
            } else {
                player.inventory.getItemStack().grow(1);
                original = player.inventory.getItemStack();
            }
            player.inventory.setItemStack(original);
            ((ServerPlayerEntity)player).connection.sendPacket((IPacket)new SSetSlotPacket(-1, -1, original));
        }
        ((PlayerEntityBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Slot;canTakeStack(Lnet/minecraft/entity/player/PlayerEntity;)Z", ordinal=4))
    public boolean onCanTakeStack(net.minecraft.inventory.container.Slot slot, PlayerEntity playerIn) {
        boolean result = slot.canTakeStack(playerIn);
        if (result) {
            this.impl$itemStackSnapshot = ItemStackUtil.snapshotOf(slot.getStack());
            this.impl$lastSlotUsed = slot;
        } else {
            this.impl$itemStackSnapshot = ItemStackSnapshot.empty();
            this.impl$lastSlotUsed = null;
        }
        return result;
    }

    @Nullable
    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=3))
    private ItemEntity onThrowClick(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemEntity entityItem = player.dropItem(itemStackIn, true);
        if (entityItem == null && ((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            ItemStack original = ItemStackUtil.fromSnapshotToNative(this.impl$itemStackSnapshot);
            this.impl$lastSlotUsed.putStack(original);
            player.openContainer.detectAndSendChanges();
            ((ServerPlayerEntity)player).isChangingQuantityOnly = false;
            ((ServerPlayerEntity)player).connection.sendPacket((IPacket)new SSetSlotPacket(player.openContainer.windowId, this.impl$lastSlotUsed.slotNumber, original));
        }
        this.impl$itemStackSnapshot = ItemStackSnapshot.empty();
        this.impl$lastSlotUsed = null;
        ((PlayerEntityBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;grow(I)V", ordinal=1)})
    private void beforeOnTakeClickWithItem(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<Integer> cir) {
        this.bridge$setPreviousCursor(player.inventory.getItemStack().copy());
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;setItemStack(Lnet/minecraft/item/ItemStack;)V", ordinal=3)})
    private void beforeOnTakeClick(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<Integer> cir) {
        this.bridge$setPreviousCursor(player.inventory.getItemStack().copy());
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Slot;onTake(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", ordinal=5))
    private ItemStack redirectOnTakeThrow(net.minecraft.inventory.container.Slot slot, PlayerEntity player, ItemStack stackToDrop) {
        this.bridge$setLastCraft(null);
        ItemStack result = slot.onTake(player, stackToDrop);
        CraftItemEvent.Craft lastCraft = this.bridge$getLastCraft();
        if (lastCraft != null && slot instanceof CraftingResultSlot && lastCraft.isCancelled()) {
            stackToDrop.setCount(0);
        }
        return result;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;transferStackInSlot(Lnet/minecraft/entity/player/PlayerEntity;I)Lnet/minecraft/item/ItemStack;"))
    private ItemStack redirectTransferStackInSlot(net.minecraft.inventory.container.Container thisContainer, PlayerEntity player, int slotId) {
        net.minecraft.inventory.container.Slot slot = thisContainer.getSlot(slotId);
        if (!(slot instanceof CraftingResultSlot)) {
            return thisContainer.transferStackInSlot(player, slotId);
        }
        this.bridge$setLastCraft(null);
        this.bridge$setShiftCrafting(true);
        ItemStack result = thisContainer.transferStackInSlot(player, slotId);
        CraftItemEvent.Craft lastCraft = this.bridge$getLastCraft();
        if (lastCraft != null && lastCraft.isCancelled()) {
            result = ItemStack.EMPTY;
        }
        this.bridge$setShiftCrafting(false);
        return result;
    }

    @Inject(method={"slotClick"}, at={@At(value="RETURN")})
    private void onReturn(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<ItemStack> cir) {
        this.bridge$setLastCraft(null);
        this.bridge$setPreviousCursor(null);
        if (this instanceof WorkbenchContainer || this instanceof PlayerContainer) {
            for (IContainerListener listener : this.listeners) {
                if (slotId == 0) {
                    listener.sendAllContents((net.minecraft.inventory.container.Container)this, this.shadow$getInventory());
                    continue;
                }
                listener.sendSlotContents((net.minecraft.inventory.container.Container)this, 0, (ItemStack)this.shadow$getInventory().get(0));
            }
        }
    }

    @Overwrite
    public void detectAndSendChanges() {
        this.bridge$detectAndSendChanges(false);
        this.bridge$setCapturePossible();
    }

    @Shadow
    public abstract NonNullList<ItemStack> shadow$getInventory();

    @Override
    public void bridge$detectAndSendChanges(boolean captureOnly) {
        net.minecraft.inventory.container.Slot slot;
        ItemStack oldStack;
        SpongeInventoryMenu menu = ((MenuBridge)((Object)this)).bridge$getMenu();
        boolean readOnlyCancel = false;
        ArrayList<Integer> changes = new ArrayList<Integer>();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            net.minecraft.inventory.container.Slot slot2 = this.inventorySlots.get(i);
            ItemStack newStack = slot2.getStack();
            oldStack = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changes.add(i);
            if (menu == null || !menu.isReadOnly() || slot2.inventory != menu.getInventory()) continue;
            readOnlyCancel = true;
        }
        if (readOnlyCancel) {
            for (Integer i : changes) {
                slot = this.inventorySlots.get(i);
                oldStack = (ItemStack)this.inventoryItemStacks.get(i.intValue());
                slot.putStack(oldStack.copy());
                this.impl$sendSlotContents(i, oldStack);
                for (IContainerListener listener : this.listeners) {
                    if (!(listener instanceof ServerPlayerEntity)) continue;
                    ((ServerPlayerEntity)listener).inventory.setItemStack(menu.getOldCursor());
                    ((ServerPlayerEntity)listener).updateHeldItem();
                }
            }
        } else {
            for (Integer i : changes) {
                slot = this.inventorySlots.get(i);
                ItemStack newStack = slot.getStack();
                ItemStack oldStack2 = (ItemStack)this.inventoryItemStacks.get(i.intValue());
                if (menu != null && !menu.onChange(newStack, oldStack2, (Container)((Object)this), i, slot)) {
                    this.inventoryItemStacks.set(i.intValue(), (Object)oldStack2.copy());
                    this.impl$sendSlotContents(i, oldStack2);
                    continue;
                }
                this.impl$capture(i, newStack, oldStack2);
                if (captureOnly) continue;
                oldStack2 = newStack.isEmpty() ? ItemStack.EMPTY : newStack.copy();
                this.inventoryItemStacks.set(i.intValue(), (Object)oldStack2);
                for (IContainerListener listener : this.listeners) {
                    listener.sendSlotContents((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack2);
                }
            }
        }
        if (menu != null) {
            menu.setOldCursor(null);
        }
        this.impl$detectAndSendPropertyChanges();
        if (this instanceof PlayerContainerBridge) {
            ((PlayerContainerBridge)((Object)this)).bridge$markClean();
        }
    }

    public void impl$sendSlotContents(Integer i, ItemStack oldStack) {
        for (IContainerListener listener : this.listeners) {
            boolean isChangingQuantityOnly = true;
            if (listener instanceof ServerPlayerEntity) {
                isChangingQuantityOnly = ((ServerPlayerEntity)listener).isChangingQuantityOnly;
                ((ServerPlayerEntity)listener).isChangingQuantityOnly = false;
            }
            listener.sendSlotContents((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack);
            if (!(listener instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)listener).isChangingQuantityOnly = isChangingQuantityOnly;
        }
    }

    private void impl$detectAndSendPropertyChanges() {
        for (int j = 0; j < this.trackedIntReferences.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.trackedIntReferences.get(j);
            if (!intreferenceholder.isDirty()) continue;
            for (IContainerListener icontainerlistener1 : this.listeners) {
                icontainerlistener1.sendWindowProperty((net.minecraft.inventory.container.Container)this, j, intreferenceholder.get());
            }
        }
    }

    private void impl$capture(Integer index, ItemStack itemstack, ItemStack itemstack1) {
        if (this.bridge$capturingInventory()) {
            ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(itemstack1);
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(itemstack);
            try {
                Slot adapter = this.inventoryAdapter$getSlot(index).get();
                SlotTransaction newTransaction = new SlotTransaction(adapter, originalItem, newItem);
                List<SlotTransaction> previewTransactions = this.bridge$getPreviewTransactions();
                if (this.bridge$isShiftCrafting()) {
                    previewTransactions.add(newTransaction);
                } else {
                    SlotTransaction previewTransaction;
                    if (!previewTransactions.isEmpty() && (previewTransaction = previewTransactions.get(0)).equals(newTransaction)) {
                        newTransaction = null;
                    }
                    if (newTransaction != null) {
                        this.bridge$getCapturedSlotTransactions().add(newTransaction);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                SpongeCommon.getLogger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
            }
        }
    }
}

