/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={RepairContainer.class})
public abstract class RepairContainerMixin_Inventory {
    @Shadow
    private String repairedItemName;
    @Shadow
    @Final
    private IInventory outputSlot;
    @Shadow
    @Final
    private IntReferenceHolder maximumCost;
    @Shadow
    private int materialCost;
    @Shadow
    @Final
    private IInventory inputSlots;

    @Inject(method={"updateRepairOutput"}, at={@At(value="RETURN")})
    private void impl$throwUpdateAnvilEvent(CallbackInfo ci) {
        if (!ShouldFire.UPDATE_ANVIL_EVENT || !PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        ItemStack itemstack = this.inputSlots.getStackInSlot(0);
        ItemStack itemstack2 = this.inputSlots.getStackInSlot(1);
        ItemStack result = this.outputSlot.getStackInSlot(0);
        UpdateAnvilEvent event = InventoryEventFactory.callUpdateAnvilEvent((RepairContainer)this, itemstack, itemstack2, result, this.repairedItemName, this.maximumCost.get(), this.materialCost);
        ItemStackSnapshot finalItem = event.getResult().getFinal();
        if (event.isCancelled() || finalItem.isEmpty()) {
            this.outputSlot.setInventorySlotContents(0, ItemStack.EMPTY);
            this.maximumCost.set(0);
            this.materialCost = 0;
            ((RepairContainer)this).detectAndSendChanges();
            return;
        }
        this.outputSlot.setInventorySlotContents(0, ItemStackUtil.fromSnapshotToNative(event.getResult().getFinal()));
        this.maximumCost.set(event.getCosts().getFinal().getLevelCost());
        this.materialCost = event.getCosts().getFinal().getMaterialCost();
        ((RepairContainer)this).detectAndSendChanges();
    }
}

