/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.tileentity;

import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.util.Direction;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.accessor.tileentity.HopperTileEntityAccessor;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.util.InventoryUtil;

@Mixin(value={HopperTileEntity.class})
public abstract class HopperTileEntityMixin_Inventory {
    @Shadow
    protected abstract boolean shadow$isInventoryFull(IInventory var1, Direction var2);

    @Redirect(method={"pullItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/HopperTileEntity;isInventoryEmpty(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/util/Direction;)Z"))
    private static boolean impl$throwTransferPreIfNotEmpty(IInventory inventory, Direction facing, IHopper hopper) {
        boolean result = HopperTileEntityAccessor.accsssor$isInventoryEmpty(inventory, facing);
        if (result || !ShouldFire.TRANSFER_INVENTORY_EVENT_PRE) {
            return result;
        }
        return InventoryEventFactory.callTransferPre(InventoryUtil.toInventory(inventory), InventoryUtil.toInventory((IInventory)hopper)).isCancelled();
    }

    @Redirect(method={"transferItemsOut"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/HopperTileEntity;isInventoryFull(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/util/Direction;)Z"))
    private boolean impl$throwTransferPreIfNotFull(HopperTileEntity hopper, IInventory inventory, Direction enumfacing) {
        boolean result = this.shadow$isInventoryFull(inventory, enumfacing);
        if (result || !ShouldFire.TRANSFER_INVENTORY_EVENT_PRE) {
            return result;
        }
        return InventoryEventFactory.callTransferPre(InventoryUtil.toInventory((IInventory)hopper), InventoryUtil.toInventory(inventory)).isCancelled();
    }

    @Redirect(method={"putStackInInventoryAllSlots"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/HopperTileEntity;insertStack(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/item/ItemStack;ILnet/minecraft/util/Direction;)Lnet/minecraft/item/ItemStack;"))
    private static ItemStack impl$throwEventsForInsertion(IInventory source, IInventory destination, ItemStack stack, int index, Direction direction) {
        if (!(source instanceof TrackedInventoryBridge) && !(destination instanceof TrackedInventoryBridge) || !(destination instanceof InventoryAdapter)) {
            return HopperTileEntityAccessor.accsssor$insertStack(source, destination, stack, index, direction);
        }
        if (!ShouldFire.TRANSFER_INVENTORY_EVENT_POST) {
            return HopperTileEntityAccessor.accsssor$insertStack(source, destination, stack, index, direction);
        }
        TrackedInventoryBridge captureIn = HopperTileEntityMixin_Inventory.impl$forCapture(source);
        if (captureIn == null) {
            captureIn = HopperTileEntityMixin_Inventory.impl$forCapture(destination);
        }
        return InventoryEventFactory.captureTransaction(captureIn, InventoryUtil.toInventory(destination), index, () -> HopperTileEntityAccessor.accsssor$insertStack(source, destination, stack, index, direction));
    }

    @Inject(method={"transferItemsOut"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=1)})
    private void impl$afterPutStackInSlots(CallbackInfoReturnable<Boolean> cir, IInventory iInventory, Direction enumFacing, int i, ItemStack itemStack, ItemStack itemStack1) {
        if (ShouldFire.TRANSFER_INVENTORY_EVENT_POST && itemStack1.isEmpty()) {
            TrackedInventoryBridge capture = HopperTileEntityMixin_Inventory.impl$forCapture(this);
            SlotTransaction sourceSlotTransaction = InventoryEventFactory.captureTransaction(capture, (Inventory)((Object)this), i, itemStack);
            InventoryEventFactory.callTransferPost(capture, (Inventory)((Object)this), InventoryUtil.toInventory(iInventory), itemStack, sourceSlotTransaction);
        }
    }

    @Inject(method={"pullItemFromSlot"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=1)})
    private static void imlp$throwTransferEventsWhenPullingItems(IHopper hopper, IInventory iInventory, int index, Direction direction, CallbackInfoReturnable<Boolean> cir, ItemStack itemStack, ItemStack itemStack1, ItemStack itemStack2) {
        if (ShouldFire.TRANSFER_INVENTORY_EVENT_POST && itemStack2.isEmpty()) {
            TrackedInventoryBridge capture = HopperTileEntityMixin_Inventory.impl$forCapture(hopper);
            SlotTransaction sourceSlotTransaction = InventoryEventFactory.captureTransaction(capture, InventoryUtil.toInventory(iInventory), index, itemStack1);
            InventoryEventFactory.callTransferPost(capture, InventoryUtil.toInventory(iInventory), InventoryUtil.toInventory((IInventory)hopper), itemStack1, sourceSlotTransaction);
        }
    }

    @Redirect(method={"captureItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/HopperTileEntity;putStackInInventoryAllSlots(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/Direction;)Lnet/minecraft/item/ItemStack;"))
    private static ItemStack impl$onPutStackInInventoryAllSlots(IInventory source, IInventory destination, ItemStack stack, Direction direction, IInventory d2, ItemEntity entity) {
        return InventoryEventFactory.callInventoryPickupEvent(destination, entity, stack);
    }

    @Nullable
    private static TrackedInventoryBridge impl$forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }
}

