/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.entity.player;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;

@Mixin(value={PlayerInventory.class})
public abstract class PlayerInventoryMixin_Bridge_Inventory
implements PlayerInventoryBridge,
InventoryAdapter {
    @Shadow
    public int currentItem;
    @Shadow
    @Final
    public PlayerEntity player;
    @Shadow
    @Final
    public NonNullList<ItemStack> mainInventory;
    @Shadow
    @Final
    public NonNullList<ItemStack> armorInventory;
    @Shadow
    @Final
    public NonNullList<ItemStack> offHandInventory;
    @Shadow
    @Final
    private List<NonNullList<ItemStack>> allInventories;
    @Shadow
    private int timesChanged;
    private int impl$lastTimesChanged;
    private int impl$offhandIndex;

    public PlayerInventoryMixin_Bridge_Inventory() {
        this.impl$lastTimesChanged = this.timesChanged;
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")}, remap=false)
    private void onConstructed(PlayerEntity playerIn, CallbackInfo ci) {
        for (NonNullList<ItemStack> inventory : this.allInventories) {
            if (inventory == this.offHandInventory) break;
            this.impl$offhandIndex += inventory.size();
        }
    }

    @Override
    public int bridge$getHeldItemIndex(Hand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return this.currentItem;
            }
            case OFF_HAND: {
                return this.impl$offhandIndex;
            }
        }
        throw new AssertionError(hand);
    }

    @Override
    public void bridge$setSelectedItem(int itemIndex, boolean notify) {
        itemIndex %= 9;
        if (notify && this.player instanceof ServerPlayerEntity) {
            SHeldItemChangePacket packet = new SHeldItemChangePacket(itemIndex);
            ((ServerPlayerEntity)this.player).connection.sendPacket((IPacket)packet);
        }
        this.currentItem = itemIndex;
    }

    @Override
    public void bridge$cleanupDirty() {
        if (this.timesChanged != this.impl$lastTimesChanged) {
            this.player.openContainer.detectAndSendChanges();
        }
    }

    @Override
    public void bridge$markClean() {
        this.impl$lastTimesChanged = this.timesChanged;
    }
}

