/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.inventory.container;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.inventory.InventoryBridge;
import org.spongepowered.common.inventory.fabric.Fabric;

@Mixin(value={Container.class})
public abstract class ContainerMixin_Fabric_Inventory
implements Fabric,
InventoryBridge {
    @Shadow
    public List<Slot> inventorySlots;
    @Nullable
    private Set<InventoryBridge> all;

    @Shadow
    public abstract Slot getSlot(int var1);

    @Shadow
    public abstract void detectAndSendChanges();

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        if (this.all == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Slot slot : this.inventorySlots) {
                if (slot.inventory == null) continue;
                builder.add((Object)((InventoryBridge)slot.inventory));
            }
            this.all = builder.build();
        }
        return this.all;
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        if (this.inventorySlots.isEmpty()) {
            return null;
        }
        return (InventoryBridge)this.getSlot((int)index).inventory;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.getSlot(index).getStack();
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.getSlot(index).putStack(stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return this.fabric$allInventories().stream().map(b -> b.bridge$getAdapter().inventoryAdapter$getFabric()).mapToInt(Fabric::fabric$getMaxStackSize).max().orElse(0);
    }

    @Override
    public int fabric$getSize() {
        return this.inventorySlots.size();
    }

    @Override
    public void fabric$clear() {
        for (Slot slot : this.inventorySlots) {
            slot.putStack(ItemStack.EMPTY);
        }
    }

    @Override
    public void fabric$markDirty() {
        this.detectAndSendChanges();
    }
}

