/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.entity;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.entity.EntityTrackedBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;

@Mixin(value={Entity.class})
public abstract class EntityMixin_Tracker
implements TrackableBridge,
EntityTrackedBridge {
    @Shadow
    @Final
    private EntityType<?> type;
    @Shadow
    public World world;
    @Shadow
    public boolean removed;
    @Shadow
    public double posX;
    @Shadow
    public double posY;
    @Shadow
    public double posZ;
    @Shadow
    public float rotationYaw;
    @Shadow
    public float rotationPitch;
    @Shadow
    @Final
    protected Random rand;
    private boolean tracker$trackedInWorld = false;
    private @Nullable Cause tracker$destructCause;
    protected @MonotonicNonNull EffectTransactor tracker$dropsTransactor = null;

    @Shadow
    public abstract void shadow$extinguish();

    @Shadow
    protected abstract void shadow$setFlag(int var1, boolean var2);

    @Shadow
    public abstract @Nullable Team getTeam();

    @Shadow
    public abstract void shadow$setPosition(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$setMotion(Vec3d var1);

    @Shadow
    public abstract void shadow$setMotion(double var1, double var3, double var5);

    @Shadow
    public abstract float getEyeHeight();

    @Shadow
    public abstract UUID getUniqueID();

    @Shadow
    protected abstract void shadow$setPose(Pose var1);

    @Shadow
    protected abstract void shadow$recenterBoundingBox();

    @Inject(method={"entityDropItem(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    private void tracker$logEntityDropTransactionIfNecessary(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((WorldBridge)this.world).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.state.doesBlockEventTracking(context)) {
            return;
        }
        if (this.tracker$dropsTransactor == null) {
            this.tracker$dropsTransactor = context.getTransactor().ensureEntityDropTransactionEffect((Entity)this);
        }
    }

    @Inject(method={"remove()V"}, at={@At(value="RETURN")})
    private void tracker$ensureDropEffectCompleted(CallbackInfo ci) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((WorldBridge)this.world).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.state.doesBlockEventTracking(context)) {
            return;
        }
        if (this.tracker$dropsTransactor != null) {
            this.tracker$dropsTransactor.close();
        }
    }

    @Override
    public boolean bridge$isWorldTracked() {
        return this.tracker$trackedInWorld;
    }

    @Override
    public void bridge$setWorldTracked(boolean tracked) {
        this.tracker$trackedInWorld = tracked;
        if (!tracked && this.tracker$destructCause != null) {
            Audience originalChannel = Audience.empty();
            SpongeCommon.postEvent(SpongeEventFactory.createDestructEntityEvent(this.tracker$destructCause, originalChannel, Optional.of(originalChannel), (Component)Component.empty(), (Component)Component.empty(), (org.spongepowered.api.entity.Entity)((Object)this), false));
            this.tracker$destructCause = null;
        }
    }

    @Override
    public boolean bridge$shouldTick() {
        return true;
    }

    @Override
    public boolean bridge$allowsBlockBulkCaptures() {
        return ((TrackableBridge)this.type).bridge$allowsBlockBulkCaptures();
    }

    @Override
    public void bridge$setAllowsBlockBulkCaptures(boolean allowsBlockBulkCaptures) {
        ((TrackableBridge)this.type).bridge$setAllowsBlockBulkCaptures(allowsBlockBulkCaptures);
    }

    @Override
    public boolean bridge$allowsBlockEventCreation() {
        return ((TrackableBridge)this.type).bridge$allowsBlockEventCreation();
    }

    @Override
    public void bridge$setAllowsBlockEventCreation(boolean allowsBlockEventCreation) {
        ((TrackableBridge)this.type).bridge$setAllowsBlockEventCreation(allowsBlockEventCreation);
    }

    @Override
    public boolean bridge$allowsEntityBulkCaptures() {
        return ((TrackableBridge)this.type).bridge$allowsEntityBulkCaptures();
    }

    @Override
    public void bridge$setAllowsEntityBulkCaptures(boolean allowsEntityBulkCaptures) {
        ((TrackableBridge)this.type).bridge$setAllowsEntityBulkCaptures(allowsEntityBulkCaptures);
    }

    @Override
    public boolean bridge$allowsEntityEventCreation() {
        return ((TrackableBridge)this.type).bridge$allowsEntityEventCreation();
    }

    @Override
    public void bridge$setAllowsEntityEventCreation(boolean allowsEntityEventCreation) {
        ((TrackableBridge)this.type).bridge$setAllowsEntityEventCreation(allowsEntityEventCreation);
    }

    @Override
    public void bridge$refreshTrackerStates() {
        ((TrackableBridge)this.type).bridge$refreshTrackerStates();
    }

    @Override
    public void populateFrameModifier(CauseStackManager.StackFrame frame, EntityTickContext context) {
    }
}

