/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.mixin.tracker.entity.EntityMixin_Tracker;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Tracker
extends EntityMixin_Tracker {
    @Shadow
    protected boolean dead;
    @Shadow
    protected int scoreValue;
    @Shadow
    protected int recentlyHit;

    @Shadow
    protected abstract void shadow$onDeathUpdate();

    @Shadow
    protected abstract int shadow$getExperiencePoints(PlayerEntity var1);

    @Shadow
    protected abstract boolean shadow$canDropLoot();

    @Shadow
    protected abstract void shadow$dropLoot(DamageSource var1, boolean var2);

    @Shadow
    protected abstract void shadow$dropInventory();

    @Shadow
    public abstract CombatTracker shadow$getCombatTracker();

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$getAttackingEntity();

    @Shadow
    public void shadow$onDeath(DamageSource cause) {
    }

    @Shadow
    protected abstract void shadow$spawnDrops(DamageSource var1);

    @Shadow
    protected abstract void shadow$createWitherRose(@Nullable LivingEntity var1);

    @Shadow
    public abstract boolean shadow$isServerWorld();

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeathUpdate()V"))
    private void tracker$enterDeathPhase(LivingEntity livingEntity) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            this.shadow$onDeathUpdate();
            return;
        }
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.shadow$onDeathUpdate();
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.state.doesBlockEventTracking(context)) {
            this.shadow$onDeathUpdate();
            return;
        }
        try (EffectTransactor ignored = context.getTransactor().ensureEntityDropTransactionEffect((Entity)((LivingEntity)this));){
            this.shadow$onDeathUpdate();
        }
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/util/DamageSource;)V"))
    private void tracker$wrapOnDeathWithState(LivingEntity thisEntity, DamageSource cause) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((WorldBridge)this.world).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.state.doesBlockEventTracking(context)) {
            return;
        }
        try (EffectTransactor ignored = context.getTransactor().ensureEntityDropTransactionEffect((Entity)((LivingEntity)this));){
            this.shadow$onDeath(cause);
        }
    }
}

