/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.entity.player;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.stats.Stat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.tracker.entity.LivingEntityMixin_Tracker;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin_Tracker
extends LivingEntityMixin_Tracker {
    @Shadow
    @Final
    public PlayerInventory inventory;

    @Shadow
    public abstract void shadow$addStat(Stat<?> var1);

    @Shadow
    public abstract void shadow$addStat(ResourceLocation var1);

    @Shadow
    public abstract ITextComponent shadow$getDisplayName();

    @Shadow
    protected abstract void shadow$spawnShoulderEntities();

    @Shadow
    protected abstract void shadow$destroyVanishingCursedItems();

    @Shadow
    public abstract String shadow$getScoreboardName();

    @Shadow
    public abstract Scoreboard shadow$getWorldScoreboard();

    @Shadow
    public abstract boolean shadow$isSpectator();

    @Shadow
    public abstract void shadow$takeStat(Stat<?> var1);

    @Shadow
    public abstract void shadow$addStat(Stat<?> var1, int var2);

    @Inject(method={"onDeath"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$callDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        DestructEntityEvent.Death event;
        if (this.shadow$isServerWorld() && (event = SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((PlayerEntity)this), cause)).isCancelled()) {
            ci.cancel();
        }
    }

    @Nullable
    @Overwrite
    public ItemEntity dropItem(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem.isEmpty()) {
            return null;
        }
        if (!((WorldBridge)this.world).bridge$isFake()) {
            ((PlayerEntityBridge)((Object)this)).bridge$shouldRestoreInventory(false);
            PlayerEntity player = (PlayerEntity)((PlayerEntityBridge)((Object)this));
            double posX1 = player.getPosX();
            double posY1 = player.getPosY() - 0.3 + (double)player.getEyeHeight();
            double posZ1 = player.getPosZ();
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(droppedItem);
            ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
            original.add(snapshot);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent((Entity)((PlayerEntity)((PlayerEntityBridge)((Object)this))), posX1, posY1, posZ1, snapshot, original, frame);
                if (item == null || item.isEmpty()) {
                    ItemEntity itemEntity = null;
                    return itemEntity;
                }
                ItemEntity itemEntity = new ItemEntity(player.world, posX1, posY1, posZ1, droppedItem);
                itemEntity.setPickupDelay(40);
                if (traceItem) {
                    itemEntity.setThrowerId(player.getUniqueID());
                }
                Random random = player.getRNG();
                if (dropAround) {
                    float f = random.nextFloat() * 0.5f;
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    itemEntity.setMotion((double)(-MathHelper.sin((float)f1) * f), (double)0.2f, (double)(MathHelper.cos((float)f1) * f));
                } else {
                    float f8 = MathHelper.sin((float)(this.rotationPitch * ((float)Math.PI / 180)));
                    float f2 = MathHelper.cos((float)(this.rotationPitch * ((float)Math.PI / 180)));
                    float f3 = MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180)));
                    float f4 = MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180)));
                    float f5 = this.rand.nextFloat() * ((float)Math.PI * 2);
                    float f6 = 0.02f * this.rand.nextFloat();
                    itemEntity.setMotion((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                }
                ItemEntity itemEntity2 = itemEntity;
                return itemEntity2;
            }
        }
        double d0 = this.posY - (double)0.3f + (double)this.getEyeHeight();
        ItemEntity itemEntity = new ItemEntity(this.world, this.posX, d0, this.posZ, droppedItem);
        itemEntity.setPickupDelay(40);
        if (traceItem) {
            itemEntity.setThrowerId(this.getUniqueID());
        }
        if (dropAround) {
            float f = this.rand.nextFloat() * 0.5f;
            float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
            itemEntity.setMotion((double)(-MathHelper.sin((float)f1) * f), (double)0.2f, (double)(MathHelper.cos((float)f1) * f));
        } else {
            float f8 = MathHelper.sin((float)(this.rotationPitch * ((float)Math.PI / 180)));
            float f2 = MathHelper.cos((float)(this.rotationPitch * ((float)Math.PI / 180)));
            float f3 = MathHelper.sin((float)(this.rotationYaw * ((float)Math.PI / 180)));
            float f4 = MathHelper.cos((float)(this.rotationYaw * ((float)Math.PI / 180)));
            float f5 = this.rand.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.rand.nextFloat();
            itemEntity.setMotion((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        return itemEntity;
    }
}

