/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.chunk;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.hooks.SpongeHooks;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_CreatorTracked
implements ChunkBridge {
    private Map<Integer, PlayerTracker> tracker$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> tracker$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Shadow
    public abstract World shadow$getWorld();

    @Shadow
    public abstract ChunkPos shadow$getPos();

    @Shadow
    public abstract Map<BlockPos, TileEntity> shadow$getTileEntityMap();

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type type) {
        InheritableConfigHandle<WorldConfig> configAdapter;
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getCurrentState().tracksCreatorsAndNotifiers()) {
            return;
        }
        if (user instanceof ServerPlayerEntity && SpongeImplHooks.isFakePlayer((Entity)((ServerPlayerEntity)user))) {
            return;
        }
        TileEntity tileEntity = this.shadow$getTileEntityMap().get(pos);
        if (tileEntity != null && tileEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)tileEntity;
            if (type == PlayerTracker.Type.NOTIFIER) {
                if (creatorBridge.tracked$getNotifierReference().orElse(null) == user) {
                    return;
                }
                creatorBridge.tracked$setNotifier(user);
            } else {
                if (creatorBridge.tracked$getCreatorReference().orElse(null) == user) {
                    return;
                }
                creatorBridge.tracked$setCreatorReference(user);
            }
        }
        if (((WorldConfig)(configAdapter = ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getConfigAdapter()).get()).getLogging().blockTrackLogging()) {
            if (!((WorldConfig)configAdapter.get()).getBlockTracking().getBlockBlacklist().contains(((BlockType)block).getKey().getFormatted())) {
                SpongeHooks.logBlockTrack(this.shadow$getWorld(), block, pos, user, true);
            } else {
                SpongeHooks.logBlockTrack(this.shadow$getWorld(), block, pos, user, false);
            }
        }
        WorldInfoBridge infoBridge = (WorldInfoBridge)this.shadow$getWorld().getWorldInfo();
        int indexForUniqueId = infoBridge.bridge$getIndexForUniqueId(user.getUniqueId());
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker playerTracker = this.tracker$trackedShortBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (type == PlayerTracker.Type.CREATOR) {
                    playerTracker.creatorindex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.tracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, type));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker playerTracker = this.tracker$trackedIntBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (type == PlayerTracker.Type.CREATOR) {
                    playerTracker.creatorindex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.tracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, type));
            }
        }
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.tracker$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.tracker$trackedShortBlockPositions;
    }

    @Override
    public Optional<User> bridge$getBlockCreator(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker playerTracker = this.tracker$trackedIntBlockPositions.get(intKey);
        if (playerTracker != null) {
            int notifierIndex = playerTracker.creatorindex;
            return this.tracker$getValidatedUser(intKey, notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int notifierIndex = shortTracker.creatorindex;
            return this.tracker$getValidatedUser(shortKey, notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker playerTracker = this.tracker$trackedIntBlockPositions.get(key);
        if (playerTracker != null) {
            int creatorIndex = playerTracker.creatorindex;
            return this.tracker$getValidatedUUID(key, creatorIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int creatorIndex = shortTracker.creatorindex;
            return this.tracker$getValidatedUUID(shortKey, creatorIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<User> bridge$getBlockNotifier(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int intKey = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker playerTracker = this.tracker$trackedIntBlockPositions.get(intKey);
        if (playerTracker != null) {
            return this.tracker$getValidatedUser(intKey, playerTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUser(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker playerTracker = this.tracker$trackedIntBlockPositions.get(key);
        if (playerTracker != null) {
            return this.tracker$getValidatedUUID(key, playerTracker.notifierIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.tracker$getValidatedUUID(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getValidatedUser(int key, int creatorIndex) {
        Optional<UUID> uuid = this.tracker$getValidatedUUID(key, creatorIndex);
        if (uuid.isPresent()) {
            UUID userUniqueId = uuid.get();
            PlayerEntity player = this.shadow$getWorld().getPlayerByUuid(userUniqueId);
            if (player != null) {
                return Optional.ofNullable(((ServerPlayerEntityBridge)player).bridge$getUser());
            }
            return this.tracker$getUserFromId(userUniqueId);
        }
        return Optional.empty();
    }

    private Optional<UUID> tracker$getValidatedUUID(int key, int creatorIndex) {
        UUID uuid = ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getUniqueIdForIndex(creatorIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().getWorld().getInvalidLookupUuids().contains(uuid)) {
                this.tracker$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    private Optional<User> tracker$getUserFromId(UUID uuid) {
        SpongeUserManager userManager = this.getUserManager();
        Server server = (Server)this.shadow$getWorld().getServer();
        String username = ((SpongeServer)server).getUsernameCache().getLastKnownUsername(uuid);
        if (username != null && userManager != null) {
            return userManager.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = server.getGameProfileManager().getCache().getById(uuid).orElse(null);
        if (profile != null && userManager != null) {
            return userManager.get(profile);
        }
        ((SpongeGameProfileManager)server.getGameProfileManager()).lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.tracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.tracker$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.notifierIndex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.tracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        }
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        if (((WorldBridge)this.shadow$getWorld()).bridge$isFake()) {
            return;
        }
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            PlayerTracker shortTracker = this.tracker$trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.creatorindex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.tracker$trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.CREATOR));
            }
        } else {
            int blockPos = Constants.Sponge.blockPosToInt(pos);
            PlayerTracker intTracker = this.tracker$trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.creatorindex = uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid);
            } else {
                this.tracker$trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((WorldInfoBridge)this.shadow$getWorld().getWorldInfo()).bridge$getIndexForUniqueId(uuid), PlayerTracker.Type.CREATOR));
            }
        }
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.tracker$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.tracker$trackedShortBlockPositions = trackedPositions;
    }

    @Inject(method={"setLoaded(Z)V"}, at={@At(value="HEAD")})
    private void tracker$startLoad(boolean loaded, CallbackInfo callbackInfo) {
        boolean isFake = ((WorldBridge)this.shadow$getWorld()).bridge$isFake();
        if (isFake) {
            return;
        }
        if (!PhaseTracker.SERVER.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Load").centre().hr().addWrapped("Sponge relies on knowing when chunks are being loaded as chunks add entities to the parented world for management. These operations are generally not threadsafe and shouldn't be considered a \"Sponge bug \". Adding/removing entities from another thread to the world is never ok.", new Object[0]).add().add(" %s : %d, %d", new Object[]{"Chunk Pos", this.shadow$getPos().x, this.shadow$getPos().z}).add().add((Throwable)new Exception("Async Chunk Load Detected")).log(SpongeCommon.getLogger(), Level.ERROR);
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
            return;
        }
        ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER).source(this)).world(this.shadow$getWorld())).chunk((Chunk)this).buildAndSwitch();
    }

    @Inject(method={"setLoaded(Z)V"}, at={@At(value="RETURN")})
    private void tracker$endLoad(boolean loaded, CallbackInfo callbackInfo) {
        if (!((WorldBridge)this.shadow$getWorld()).bridge$isFake() && PhaseTracker.SERVER.onSidedThread()) {
            if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
                return;
            }
            PhaseTracker.getInstance().getPhaseContext().close();
        }
    }

    private SpongeUserManager getUserManager() {
        World world = this.shadow$getWorld();
        if (world == null || ((WorldBridge)world).bridge$isFake()) {
            return null;
        }
        return (SpongeUserManager)((Server)world.getServer()).getUserManager();
    }
}

