/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.server;

import co.aikar.timings.Timing;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.PistonBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.block.TrackedBlockBridge;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.TrackedChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToLoadedListInWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToTickableListEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToWorldWhileProcessingEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyClientEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyNeighborSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromChunkEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ReplaceTileEntityInWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.TileOnLoadDuringAddToWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateConnectingBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateLightSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateWorldRendererEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.TileEntityPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.mixin.tracker.world.WorldMixin_Tracker;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerWorldMixin_Tracker
extends WorldMixin_Tracker
implements TrackedWorldBridge {
    @Shadow
    @Final
    private List<ServerPlayerEntity> players;

    @Inject(method={"onEntityAdded"}, at={@At(value="TAIL")})
    private void tracker$setEntityTrackedInWorld(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (!this.bridge$isFake()) {
            ((TrackableBridge)entityIn).bridge$setWorldTracked(true);
        }
    }

    @Inject(method={"onEntityRemoved"}, at={@At(value="TAIL")})
    private void tracker$setEntityUntrackedInWorld(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (!this.bridge$isFake() || ((TrackableBridge)entityIn).bridge$isWorldTracked()) {
            ((TrackableBridge)entityIn).bridge$setWorldTracked(false);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;guardEntityTick(Ljava/util/function/Consumer;Lnet/minecraft/entity/Entity;)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;resetUpdateEntityTick()V"), to=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;int2ObjectEntrySet()Lit/unimi/dsi/fastutil/objects/ObjectSet;", remap=false)))
    private void tracker$wrapGlobalEntityTicking(net.minecraft.world.server.ServerWorld serverWorld, Consumer<net.minecraft.entity.Entity> consumer, net.minecraft.entity.Entity entity) {
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.SERVER.getPhaseContext();
        if (currentContext.state.alreadyCapturingEntityTicks()) {
            this.shadow$guardEntityTick(consumer, entity);
            return;
        }
        TrackingUtil.tickGlobalEntity(consumer, entity);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;guardEntityTick(Ljava/util/function/Consumer;Lnet/minecraft/entity/Entity;)V"), slice=@Slice(from=@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;startSection(Ljava/lang/String;)V", args={"ldc=tick"}), to=@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;startSection(Ljava/lang/String;)V", args={"ldc=remove"})))
    private void tracker$wrapNormalEntityTick(net.minecraft.world.server.ServerWorld serverWorld, Consumer<net.minecraft.entity.Entity> entityUpdateConsumer, net.minecraft.entity.Entity entity) {
        IPhaseState<@NonNull ?> currentState = PhaseTracker.SERVER.getCurrentState();
        if (currentState.alreadyCapturingEntityTicks()) {
            this.shadow$guardEntityTick(entityUpdateConsumer, entity);
            return;
        }
        TrackingUtil.tickEntity(entityUpdateConsumer, entity);
    }

    @Override
    protected void tracker$wrapTileEntityTick(ITickableTileEntity tileEntity) {
        if (!SpongeImplHooks.shouldTickTile(tileEntity)) {
            return;
        }
        IPhaseState<?> state = PhaseTracker.SERVER.getCurrentState();
        if (state.alreadyCapturingTileTicks()) {
            tileEntity.tick();
            return;
        }
        TrackingUtil.tickTileEntity(this, tileEntity);
    }

    @Redirect(method={"tickBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;tick(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockTick(net.minecraft.block.BlockState blockState, net.minecraft.world.server.ServerWorld worldIn, BlockPos posIn, Random randomIn) {
        PhaseContext<?> currentContext;
        IPhaseState currentState = currentContext.state;
        currentContext = PhaseTracker.SERVER.getPhaseContext();
        if (currentState.alreadyCapturingBlockTicks(currentContext) || currentState.ignoresBlockUpdateTick(currentContext)) {
            blockState.tick(worldIn, posIn, randomIn);
            return;
        }
        TrackingUtil.updateTickBlock(this, blockState, posIn, randomIn);
    }

    @Redirect(method={"tickFluid"}, at=@At(value="INVOKE", target="Lnet/minecraft/fluid/IFluidState;tick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"))
    private void tracker$wrapFluidTick(IFluidState fluidState, World worldIn, BlockPos pos) {
        PhaseContext<?> currentContext;
        IPhaseState currentState = currentContext.state;
        currentContext = PhaseTracker.SERVER.getPhaseContext();
        if (currentState.alreadyCapturingBlockTicks(currentContext) || currentState.ignoresBlockUpdateTick(currentContext)) {
            fluidState.tick(worldIn, pos);
            return;
        }
        TrackingUtil.updateTickFluid(this, fluidState, pos);
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;randomTick(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockRandomTick(net.minecraft.block.BlockState blockState, net.minecraft.world.server.ServerWorld worldIn, BlockPos posIn, Random randomIn) {
        try (Timing timing = ((TimingBridge)blockState.getBlock()).bridge$getTimingsHandler();){
            timing.startTiming();
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            IPhaseState phaseState = context.state;
            if (phaseState.alreadyCapturingBlockTicks(context)) {
                blockState.randomTick(worldIn, posIn, this.rand);
            } else {
                TrackingUtil.randomTickBlock(this, blockState, posIn, this.rand);
            }
        }
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Lnet/minecraft/fluid/IFluidState;randomTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapFluidRandomTick(IFluidState fluidState, World worldIn, BlockPos pos, Random random) {
        PhaseContext<?> context;
        IPhaseState phaseState = context.state;
        context = PhaseTracker.getInstance().getPhaseContext();
        if (phaseState.alreadyCapturingBlockTicks(context)) {
            fluidState.randomTick(worldIn, pos, this.rand);
        } else {
            TrackingUtil.randomTickFluid(this, fluidState, pos, this.rand);
        }
    }

    @Redirect(method={"fireBlockEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;onBlockEventReceived(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;II)Z"))
    private boolean tracker$wrapBlockStateEventReceived(net.minecraft.block.BlockState recievingState, World thisWorld, BlockPos targetPos, int eventId, int flag, BlockEventData data) {
        return TrackingUtil.fireMinecraftBlockEvent((net.minecraft.world.server.ServerWorld)this, data, recievingState);
    }

    @Redirect(method={"addBlockEvent"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;add(Ljava/lang/Object;)Z", remap=false))
    private boolean tracker$associatePhaseContextDataWithBlockEvent(ObjectLinkedOpenHashSet<BlockEventData> list, Object data, BlockPos pos, Block blockIn, int eventID, int eventParam) {
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.getInstance().getPhaseContext();
        BlockEventData blockEventData = (BlockEventData)data;
        TrackerBlockEventDataBridge blockEvent = (TrackerBlockEventDataBridge)blockEventData;
        IPhaseState phaseState = currentContext.state;
        if (phaseState.ignoresBlockEvent()) {
            return list.add((Object)blockEventData);
        }
        net.minecraft.block.BlockState state = this.shadow$getBlockState(pos);
        if (((BlockBridge)blockIn).bridge$shouldFireBlockEvents()) {
            blockEvent.bridge$setSourceUser(currentContext.getActiveUser());
            if (SpongeImplHooks.hasBlockTileEntity(state)) {
                blockEvent.bridge$setTileEntity((BlockEntity)this.shadow$getTileEntity(pos));
            }
            if (blockEvent.bridge$getTileEntity() == null) {
                LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)this)).position(pos.getX(), pos.getY(), pos.getZ()).state((BlockState)state).build();
                blockEvent.bridge$setTickingLocatable(locatable);
            }
        }
        if (!((BlockBridge)blockIn).bridge$shouldFireBlockEvents()) {
            return list.add((Object)((BlockEventData)data));
        }
        phaseState.appendNotifierToBlockEvent(currentContext, this, pos, blockEvent);
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && (blockIn instanceof PistonBlock ? SpongeCommonEventFactory.handlePistonEvent(this, pos, state, eventID) : SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)((Object)this), pos).isCancelled())) {
            return false;
        }
        currentContext.getTransactor().logBlockEvent(state, this, pos, blockEvent);
        return list.add((Object)blockEventData);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Explosion tracker$triggerInternalExplosion(org.spongepowered.api.world.explosion.Explosion explosion, Function<? super Explosion, ? extends PhaseContext<@NonNull ?>> contextCreator) {
        Explosion mcExplosion;
        Explosion originalExplosion = (Explosion)explosion;
        ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.SERVER.getCurrentCause(), explosion, (ServerWorld)((Object)this));
        if (SpongeCommon.postEvent(event)) {
            return (Explosion)explosion;
        }
        explosion = event.getExplosion();
        try {
            mcExplosion = (Explosion)explosion;
        }
        catch (Exception e) {
            new org.spongepowered.asm.util.PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add((Throwable)e).trace();
            return originalExplosion;
        }
        try (@NonNull ? ignored = contextCreator.apply((Explosion)mcExplosion).source(explosion.getSourceExplosive().orElse((Explosive)((Object)this)));){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean damagesTerrain = explosion.shouldBreakBlocks();
            mcExplosion.doExplosionA();
            mcExplosion.doExplosionB(true);
            if (!damagesTerrain) {
                mcExplosion.clearAffectedBlockPositions();
            }
            for (ServerPlayerEntity playerEntity : this.players) {
                Vec3d knockback = (Vec3d)mcExplosion.getPlayerKnockbackMap().get(playerEntity);
                if (knockback == null) continue;
                playerEntity.connection.sendPacket((IPacket)new SEntityVelocityPacket(playerEntity.getEntityId(), new Vec3d(knockback.x, knockback.y, knockback.z)));
            }
        }
        return mcExplosion;
    }

    @Override
    public Optional<WorldPipeline.Builder> bridge$startBlockChange(BlockPos pos, net.minecraft.block.BlockState newState, int flags) {
        if (World.isOutsideBuildHeight((BlockPos)pos)) {
            return Optional.empty();
        }
        if (this.worldInfo.getGenerator() == WorldType.DEBUG_ALL_BLOCK_STATES) {
            return Optional.empty();
        }
        if (this.bridge$isFake()) {
            return Optional.empty();
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        Chunk chunk = this.shadow$getChunkAt(pos);
        if (chunk.isEmpty()) {
            return Optional.empty();
        }
        net.minecraft.block.BlockState currentState = chunk.getBlockState(pos);
        return Optional.of(this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag));
    }

    private WorldPipeline.Builder bridge$makePipeline(BlockPos pos, net.minecraft.block.BlockState currentState, net.minecraft.block.BlockState newState, Chunk chunk, SpongeBlockChangeFlag spongeFlag) {
        TrackedChunkBridge mixinChunk = (TrackedChunkBridge)chunk;
        ChunkPipeline chunkPipeline = mixinChunk.bridge$createChunkPipeline(pos, newState, currentState, spongeFlag);
        WorldPipeline.Builder worldPipelineBuilder = WorldPipeline.builder(chunkPipeline);
        worldPipelineBuilder.addEffect((pipeline, oldState, newState1, flag1) -> {
            if (oldState == null) {
                return EffectResult.NULL_RETURN;
            }
            return EffectResult.NULL_PASS;
        }).addEffect(UpdateLightSideEffect.getInstance()).addEffect(CheckBlockPostPlacementIsSameEffect.getInstance()).addEffect(UpdateWorldRendererEffect.getInstance()).addEffect(NotifyClientEffect.getInstance()).addEffect(NotifyNeighborSideEffect.getInstance()).addEffect(UpdateConnectingBlocksEffect.getInstance());
        return worldPipelineBuilder;
    }

    @Override
    public boolean setBlockState(BlockPos pos, net.minecraft.block.BlockState newState, int flags) {
        if (World.isOutsideBuildHeight((BlockPos)pos)) {
            return false;
        }
        if (this.worldInfo.getGenerator() == WorldType.DEBUG_ALL_BLOCK_STATES) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.setBlockState(pos, newState, flags);
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        Chunk chunk = this.shadow$getChunkAt(pos);
        if (chunk.isEmpty()) {
            return false;
        }
        net.minecraft.block.BlockState currentState = chunk.getBlockState(pos);
        WorldPipeline pipeline = this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, newState, pos, spongeFlag);
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(net.minecraft.block.BlockState state, BlockPos pos, BlockChangeFlag updateFlag) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.reset();
        builder.blockState(state).world((net.minecraft.world.server.ServerWorld)this).position(VecHelper.toVector3i(pos));
        Chunk chunk = this.shadow$getChunkAt(pos);
        if (chunk == null) {
            return builder.flag(updateFlag).build();
        }
        Optional<UUID> creator = ((ChunkBridge)chunk).bridge$getBlockCreatorUUID(pos);
        Optional<UUID> notifier = ((ChunkBridge)chunk).bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        boolean hasTileEntity = SpongeImplHooks.hasBlockTileEntity(state);
        TileEntity tileEntity = chunk.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        if ((hasTileEntity || tileEntity != null) && tileEntity != null) {
            CompoundNBT nbt = new CompoundNBT();
            try {
                tileEntity.write(nbt);
                builder.addUnsafeCompound(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public void shadow$removeTileEntity(BlockPos pos) {
        BlockPos immutable = pos.toImmutable();
        TileEntity tileentity = this.shadow$getTileEntity(immutable);
        if (tileentity == null) {
            return;
        }
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$removeTileEntity(immutable);
            return;
        }
        PhaseContext<?> current = PhaseTracker.SERVER.getPhaseContext();
        IPhaseState state = current.state;
        if (current.getTransactor().logTileRemoval(tileentity, () -> (net.minecraft.world.server.ServerWorld)this)) {
            TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(RemoveTileEntityFromWorldEffect.getInstance()).addEffect(RemoveTileEntityFromChunkEffect.getInstance()).build();
            pipeline.processEffects(current, new PipelineCursor(tileentity.getBlockState(), 0, immutable, tileentity));
            return;
        }
        super.shadow$removeTileEntity(immutable);
    }

    @Override
    public boolean shadow$addTileEntity(TileEntity tileEntity) {
        PhaseContext<?> current;
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            return super.shadow$addTileEntity(tileEntity);
        }
        IPhaseState state = current.state;
        current = PhaseTracker.SERVER.getPhaseContext();
        if (state.doesBlockEventTracking(current)) {
            IChunk iChunk;
            BlockPos immutable = tileEntity.getPos().toImmutable();
            if (tileEntity.getWorld() != (net.minecraft.world.server.ServerWorld)this) {
                tileEntity.setWorldAndPos((World)((net.minecraft.world.server.ServerWorld)this), immutable);
            }
            if (!((iChunk = this.shadow$getChunk(immutable.getX() >> 4, immutable.getZ() >> 4, ChunkStatus.FULL, false)) instanceof Chunk)) {
                return super.shadow$addTileEntity(tileEntity);
            }
            Chunk chunk = this.shadow$getChunkAt(immutable);
            if (current.getTransactor().logTileAddition(tileEntity, () -> (net.minecraft.world.server.ServerWorld)this, chunk)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(AddTileEntityToWorldWhileProcessingEffect.getInstance()).addEffect(AddTileEntityToLoadedListInWorldEffect.getInstance()).addEffect(AddTileEntityToTickableListEffect.getInstance()).addEffect(TileOnLoadDuringAddToWorldEffect.getInstance()).build();
                return pipeline.processEffects(current, new PipelineCursor(tileEntity.getBlockState(), 0, immutable, tileEntity));
            }
        }
        return super.shadow$addTileEntity(tileEntity);
    }

    @Override
    public void shadow$setTileEntity(BlockPos pos, @Nullable TileEntity proposed) {
        PhaseContext<?> current;
        IPhaseState state;
        BlockPos immutable = pos.toImmutable();
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$setTileEntity(pos, proposed);
            return;
        }
        if (proposed != null) {
            if (proposed.getWorld() != (net.minecraft.world.server.ServerWorld)this) {
                proposed.setWorldAndPos((World)((net.minecraft.world.server.ServerWorld)this), immutable);
            } else {
                proposed.setPos(pos);
            }
        }
        if ((state = current.state).doesBlockEventTracking(current = PhaseTracker.SERVER.getPhaseContext())) {
            @Nullable TileEntity existing = this.shadow$getChunkAt(immutable).getTileEntity(immutable);
            if (current.getTransactor().logTileReplacement(immutable, existing, proposed, () -> (net.minecraft.world.server.ServerWorld)this)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect.getInstance()).addEffect(ReplaceTileEntityInWorldEffect.getInstance()).build();
                pipeline.processEffects(current, new PipelineCursor(proposed.getBlockState(), 0, immutable, proposed));
                return;
            }
        }
        super.shadow$setTileEntity(immutable, proposed);
    }

    @Override
    public void shadow$neighborChanged(BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos immutableTarget = pos.toImmutable();
        BlockPos immutableFrom = fromPos.toImmutable();
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped("Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.", new Object[0]).add().add(new Exception("Async Block Notifcation Detected")).log(SpongeCommon.getLogger(), Level.ERROR);
            return;
        }
        if (this.bridge$isFake()) {
            super.shadow$neighborChanged(immutableTarget, blockIn, immutableFrom);
            return;
        }
        Chunk targetChunk = this.shadow$getChunkAt(immutableTarget);
        net.minecraft.block.BlockState targetBlockState = targetChunk.getBlockState(immutableTarget);
        if (!((TrackedBlockBridge)targetBlockState.getBlock()).bridge$overridesNeighborNotificationLogic()) {
            return;
        }
        PhaseContext<?> peek = server.getPhaseContext();
        IPhaseState state = peek.state;
        try {
            WeakReference<net.minecraft.world.server.ServerWorld> worldReference = new WeakReference<net.minecraft.world.server.ServerWorld>((net.minecraft.world.server.ServerWorld)this);
            Supplier<net.minecraft.world.server.ServerWorld> worldSupplier = () -> (net.minecraft.world.server.ServerWorld)Objects.requireNonNull(worldReference.get(), "ServerWorld dereferenced");
            @Nullable TileEntity existingTile = targetChunk.getTileEntity(immutableTarget, Chunk.CreateEntityType.CHECK);
            peek.getTransactor().logNeighborNotification(worldSupplier, immutableFrom, blockIn, immutableTarget, targetBlockState, existingTile);
            state.associateNeighborStateNotifier(peek, immutableFrom, targetBlockState.getBlock(), immutableTarget, (net.minecraft.world.server.ServerWorld)this, PlayerTracker.Type.NOTIFIER);
            targetBlockState.neighborChanged((World)((net.minecraft.world.server.ServerWorld)this), immutableTarget, blockIn, immutableFrom, false);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being updated");
            crashreportcategory.addDetail("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Registry.BLOCK.getId((Object)blockIn), blockIn.getTranslationKey(), blockIn.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Registry.BLOCK.getId((Object)blockIn);
                }
            });
            CrashReportCategory.addBlockInfo((CrashReportCategory)crashreportcategory, (BlockPos)immutableTarget, (net.minecraft.block.BlockState)targetBlockState);
            throw new ReportedException(crashreport);
        }
    }

    @Inject(method={"addEntity0(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getPosX()D")}, cancellable=true)
    private void tracker$throwPreEventAndRecord(net.minecraft.entity.Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        PhaseContext<?> current;
        if (this.bridge$isFake()) {
            return;
        }
        PhaseTracker tracker = PhaseTracker.SERVER;
        if (tracker.getSidedThread() != Thread.currentThread()) {
            return;
        }
        Cause currentCause = tracker.getCurrentCause();
        SpawnEntityEvent.Pre pre = SpongeEventFactory.createSpawnEntityEventPre(currentCause, Collections.singletonList((Entity)entityIn));
        Sponge.getEventManager().post(pre);
        if (pre.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
        if ((current = tracker.getPhaseContext()).allowsBulkEntityCaptures()) {
            current.getTransactor().logEntitySpawn(current, this, entityIn);
        }
    }
}

