/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.api.network.status.StatusResponse;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.network.status.SpongeLegacyStatusClient;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeStatusResponse {
    private SpongeStatusResponse() {
    }

    @Nullable
    public static ServerStatusResponse post(MinecraftServer server, StatusClient client) {
        return SpongeStatusResponse.call(SpongeStatusResponse.create(server), client);
    }

    @Nullable
    public static ServerStatusResponse postLegacy(MinecraftServer server, InetSocketAddress address, MinecraftVersion version, InetSocketAddress virtualHost) {
        ServerStatusResponse response = SpongeStatusResponse.create(server);
        response.setVersion(new ServerStatusResponse.Version(response.getVersion().getName(), 127));
        response = SpongeStatusResponse.call(response, new SpongeLegacyStatusClient(address, version, virtualHost));
        if (response != null && response.getPlayers() == null) {
            response.setPlayers(new ServerStatusResponse.Players(-1, 0));
        }
        return response;
    }

    @Nullable
    private static ServerStatusResponse call(ServerStatusResponse response, StatusClient client) {
        if (!SpongeCommon.postEvent(SpongeEventFactory.createClientPingServerEvent(Cause.of(EventContext.empty(), Sponge.getServer()), client, (ClientPingServerEvent.Response)response))) {
            return response;
        }
        return null;
    }

    public static ServerStatusResponse create(MinecraftServer server) {
        return SpongeStatusResponse.clone(server.getServerStatusResponse());
    }

    private static ServerStatusResponse clone(ServerStatusResponse original) {
        ServerStatusResponse clone = new ServerStatusResponse();
        clone.setServerDescription(original.getServerDescription());
        if (original.getFavicon() != null) {
            ((ClientPingServerEvent.Response)clone).setFavicon(((StatusResponse)original).getFavicon().get());
        }
        clone.setPlayers(SpongeStatusResponse.clone(original.getPlayers()));
        clone.setVersion(SpongeStatusResponse.clone(original.getVersion()));
        return clone;
    }

    @Nullable
    private static ServerStatusResponse.Players clone(@Nullable ServerStatusResponse.Players original) {
        if (original != null) {
            ServerStatusResponse.Players clone = new ServerStatusResponse.Players(original.getMaxPlayers(), original.getOnlinePlayerCount());
            clone.setPlayers(original.getPlayers());
            return clone;
        }
        return null;
    }

    @Nullable
    private static ServerStatusResponse.Version clone(@Nullable ServerStatusResponse.Version original) {
        return original != null ? new ServerStatusResponse.Version(original.getName(), original.getProtocol()) : null;
    }

    public static String getMotd(ServerStatusResponse response) {
        return SpongeStatusResponse.getFirstLine(SpongeAdventure.legacySection(SpongeAdventure.asAdventure(response.getServerDescription())));
    }

    public static String getUnformattedMotd(ServerStatusResponse response) {
        return SpongeStatusResponse.getFirstLine(SpongeAdventure.plain(SpongeAdventure.asAdventure(response.getServerDescription())));
    }

    private static String getFirstLine(String s2) {
        return NetworkUtil.substringBefore(s2, '\n');
    }
}

