/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.RconConnection;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHandler;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingIdentifier;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsPls;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsReportListener;
import org.spongepowered.common.relocate.co.aikar.util.JSONUtil;
import org.spongepowered.configurate.ConfigurationNode;

class TimingsExport
extends Thread {
    private static final Joiner AUTHOR_LIST_JOINER = Joiner.on((String)", ");
    private static final Joiner RUNTIME_FLAG_JOINER = Joiner.on((String)" ");
    private static final Joiner CONFIG_PATH_JOINER = Joiner.on((String)".");
    private final TimingsReportListener listeners;
    private final JsonObject out;
    private final TimingHistory[] history;
    private static long lastReport = 0L;
    static final List<Audience> requestingReport = Lists.newArrayList();

    TimingsExport(TimingsReportListener listeners, JsonObject out, TimingHistory[] history) {
        super("Timings paste thread");
        this.listeners = listeners;
        this.out = out;
        this.history = history;
    }

    private static String getServerName() {
        return SpongeCommon.getPlugin().getMetadata().getName() + " " + SpongeCommon.getPlugin().getMetadata().getVersion();
    }

    static void reportTimings() {
        if (requestingReport.isEmpty()) {
            return;
        }
        TimingsReportListener listeners = new TimingsReportListener(requestingReport);
        requestingReport.clear();
        long now = System.currentTimeMillis();
        long lastReportDiff = now - lastReport;
        if (lastReportDiff < 60000L) {
            listeners.send((Component)Component.text((String)("Please wait at least 1 minute in between Timings reports. (" + (int)((60000L - lastReportDiff) / 1000L) + " seconds)"), (TextColor)NamedTextColor.RED));
            listeners.done();
            return;
        }
        long lastStartDiff = now - TimingsManager.timingStart;
        if (lastStartDiff < 180000L) {
            listeners.send((Component)Component.text((String)("Please wait at least 3 minutes before generating a Timings report. Unlike Timings v1, v2 benefits from longer timings and is not as useful with short timings. (" + (int)((180000L - lastStartDiff) / 1000L) + " seconds)"), (TextColor)NamedTextColor.RED));
            listeners.done();
            return;
        }
        listeners.send((Component)Component.text((String)"Preparing Timings Report...", (TextColor)NamedTextColor.GREEN));
        lastReport = now;
        Platform platform = SpongeCommon.getGame().getPlatform();
        JSONUtil.JsonObjectBuilder builder = JSONUtil.objectBuilder().add("version", (Object)platform.getContainer(Platform.Component.IMPLEMENTATION).getMetadata().getVersion()).add("maxplayers", (Object)SpongeCommon.getGame().getServer().getMaxPlayers()).add("start", (Object)(TimingsManager.timingStart / 1000L)).add("end", (Object)(System.currentTimeMillis() / 1000L)).add("sampletime", (Object)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L));
        if (!TimingsManager.privacy) {
            builder.add("server", (Object)TimingsExport.getServerName()).add("motd", (Object)SpongeAdventure.plain(Sponge.getServer().getMotd())).add("online-mode", (Object)Sponge.getServer().getOnlineMode()).add("icon", (Object)SpongeCommon.getServer().getServerStatusResponse().getFavicon());
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        builder.add("system", (Object)JSONUtil.objectBuilder().add("timingcost", (Object)TimingsExport.getCost()).add("name", (Object)System.getProperty("os.name")).add("version", (Object)System.getProperty("os.version")).add("jvmversion", (Object)System.getProperty("java.version")).add("arch", (Object)System.getProperty("os.arch")).add("maxmem", (Object)runtime.maxMemory()).add("cpu", (Object)runtime.availableProcessors()).add("runtime", (Object)ManagementFactory.getRuntimeMXBean().getUptime()).add("flags", (Object)RUNTIME_FLAG_JOINER.join(runtimeBean.getInputArguments())).add("gc", (Object)JSONUtil.mapArrayToObject(ManagementFactory.getGarbageCollectorMXBeans(), input -> JSONUtil.singleObjectPair(input.getName(), (Object)JSONUtil.arrayOf(input.getCollectionCount(), input.getCollectionTime())))));
        HashSet tileEntityTypeSet = Sets.newHashSet();
        HashSet entityTypeSet = Sets.newHashSet();
        int size = TimingsManager.HISTORY.size();
        TimingHistory[] history = new TimingHistory[size + 1];
        int i = 0;
        for (TimingHistory timingHistory : TimingsManager.HISTORY) {
            tileEntityTypeSet.addAll(timingHistory.tileEntityTypeSet);
            entityTypeSet.addAll(timingHistory.entityTypeSet);
            history[i++] = timingHistory;
        }
        history[i] = new TimingHistory();
        tileEntityTypeSet.addAll(history[i].tileEntityTypeSet);
        entityTypeSet.addAll(history[i].entityTypeSet);
        JSONUtil.JsonObjectBuilder handlersBuilder = JSONUtil.objectBuilder();
        for (TimingIdentifier.TimingGroup group2 : TimingIdentifier.GROUP_MAP.values()) {
            for (TimingHandler id : group2.handlers) {
                if (!id.timed && !id.isSpecial()) continue;
                handlersBuilder.add(id.id, (Object)JSONUtil.arrayOf(group2.id, id.name));
            }
        }
        builder.add("idmap", (Object)JSONUtil.objectBuilder().add("groups", (Object)JSONUtil.mapArrayToObject(TimingIdentifier.GROUP_MAP.values(), group -> JSONUtil.singleObjectPair(group.id, (Object)group.name))).add("handlers", (Object)handlersBuilder).add("worlds", (Object)JSONUtil.mapArrayToObject(TimingHistory.worldMap.entrySet(), entry -> JSONUtil.singleObjectPair((Integer)entry.getValue(), entry.getKey()))).add("tileentity", (Object)JSONUtil.mapArrayToObject(tileEntityTypeSet, tileEntityType -> JSONUtil.singleObjectPair(TimingsPls.getTileEntityId(tileEntityType), (Object)tileEntityType.getKey().toString()))).add("entity", (Object)JSONUtil.mapArrayToObject(entityTypeSet, entityType -> JSONUtil.singleObjectPair(TimingsPls.getEntityId(entityType), (Object)entityType.getKey().toString()))));
        builder.add("plugins", (Object)JSONUtil.mapArrayToObject(SpongeCommon.getGame().getPluginManager().getPlugins(), plugin -> JSONUtil.objectBuilder().add(plugin.getMetadata().getId(), (Object)JSONUtil.objectBuilder().add("version", (Object)plugin.getMetadata().getVersion()).add("description", (Object)plugin.getMetadata().getDescription().orElse("")).add("website", (Object)plugin.getMetadata().getLinks().getHomepage()).add("authors", (Object)AUTHOR_LIST_JOINER.join((Iterable)plugin.getMetadata().getContributors()))).build()));
        builder.add("config", (Object)JSONUtil.objectBuilder().add("sponge", (Object)TimingsExport.serializeConfigNode(SpongeConfigs.getCommon().getNode())));
        new TimingsExport(listeners, builder.build(), history).start();
    }

    static long getCost() {
        int passes = 200;
        TimingHandler SAMPLER1 = SpongeTimingsFactory.ofSafe("Timings Sampler 1");
        TimingHandler SAMPLER2 = SpongeTimingsFactory.ofSafe("Timings Sampler 2");
        TimingHandler SAMPLER3 = SpongeTimingsFactory.ofSafe("Timings Sampler 3");
        TimingHandler SAMPLER4 = SpongeTimingsFactory.ofSafe("Timings Sampler 4");
        TimingHandler SAMPLER5 = SpongeTimingsFactory.ofSafe("Timings Sampler 5");
        TimingHandler SAMPLER6 = SpongeTimingsFactory.ofSafe("Timings Sampler 6");
        long start = System.nanoTime();
        for (int i = 0; i < passes; ++i) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER3.stopTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    private static JsonElement serializeConfigNode(ConfigurationNode node) {
        if (node.isMap()) {
            JsonObject object = new JsonObject();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                String fullPath = CONFIG_PATH_JOINER.join((Iterable)entry.getValue().path());
                if (fullPath.equals("sponge.sql") || TimingsManager.hiddenConfigs.contains(fullPath)) continue;
                object.add(entry.getKey().toString(), TimingsExport.serializeConfigNode(entry.getValue()));
            }
            return object;
        }
        if (node.isList()) {
            JsonArray array = new JsonArray();
            for (ConfigurationNode configurationNode : node.childrenList()) {
                array.add(TimingsExport.serializeConfigNode(configurationNode));
            }
            return array;
        }
        return JSONUtil.toJsonElement(node.raw());
    }

    @Override
    public synchronized void start() {
        boolean containsRconSource = false;
        for (Audience receiver : this.listeners.getChannel().audiences()) {
            if (!(receiver instanceof RconConnection)) continue;
            containsRconSource = true;
            break;
        }
        if (containsRconSource) {
            this.listeners.send((Component)Component.text((String)"Warning: Timings report done over RCON will cause lag spikes.", (TextColor)NamedTextColor.RED));
            this.listeners.send(((TextComponent)Component.text((String)"You should use ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"/sponge timings report", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" in game or console.", (TextColor)NamedTextColor.RED)));
            this.run();
        } else {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.out.add("data", JSONUtil.mapArray(this.history, TimingHistory::export));
        String response = null;
        String timingsURL = null;
        try {
            String hostname = "localhost";
            if (!TimingsManager.privacy) {
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (IOException e) {
                    SpongeCommon.getLogger().warn("Could not get own server hostname when uploading timings - falling back to 'localhost'", (Throwable)e);
                }
            }
            HttpURLConnection con = (HttpURLConnection)new URL("https://timings.aikar.co/post").openConnection();
            con.setDoOutput(true);
            String name = TimingsManager.privacy ? "" : TimingsExport.getServerName();
            con.setRequestProperty("User-Agent", "Sponge/" + name + "/" + hostname);
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(false);
            GZIPOutputStream request = new GZIPOutputStream(con.getOutputStream()){
                {
                    this.def.setLevel(7);
                }
            };
            ((OutputStream)request).write(JSONUtil.toString(this.out).getBytes("UTF-8"));
            ((OutputStream)request).close();
            response = this.getResponse(con);
            if (con.getResponseCode() != 302) {
                this.listeners.send((Component)Component.text((String)("Upload Error: " + con.getResponseCode() + ": " + con.getResponseMessage()), (TextColor)NamedTextColor.RED));
                this.listeners.send((Component)Component.text((String)"Check your logs for more information", (TextColor)NamedTextColor.RED));
                if (response != null) {
                    SpongeCommon.getLogger().fatal(response);
                }
                this.listeners.done(timingsURL);
                return;
            }
            timingsURL = con.getHeaderField("Location");
            this.listeners.send((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("View Timings Report: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)timingsURL).clickEvent(ClickEvent.openUrl((String)timingsURL)))).build());
            if (response != null && !response.isEmpty()) {
                SpongeCommon.getLogger().info("Timing Response: " + response);
            }
            this.listeners.done(timingsURL);
        }
        catch (IOException ex) {
            this.listeners.send((Component)Component.text((String)"Error uploading timings, check your logs for more information", (TextColor)NamedTextColor.RED));
            if (response != null) {
                SpongeCommon.getLogger().fatal(response);
            }
            SpongeCommon.getLogger().fatal("Could not paste timings", (Throwable)ex);
        }
        finally {
            this.listeners.done(timingsURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = null;){
            int bytesRead;
            is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((bytesRead = is.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
    }
}

