/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;

public final class PerWorldBorderListener
implements IBorderListener {
    private final ServerWorld world;

    public PerWorldBorderListener(ServerWorld world) {
        this.world = world;
    }

    public void onSizeChanged(WorldBorder border, double newSize) {
        this.sendWorldBorderActionPacket(border, SWorldBorderPacket.Action.SET_SIZE);
    }

    public void onTransitionStarted(WorldBorder border, double oldSize, double newSize, long time) {
        this.sendWorldBorderActionPacket(border, SWorldBorderPacket.Action.LERP_SIZE);
    }

    public void onCenterChanged(WorldBorder border, double x, double z) {
        this.sendWorldBorderActionPacket(border, SWorldBorderPacket.Action.SET_CENTER);
    }

    public void onWarningTimeChanged(WorldBorder border, int newTime) {
        this.sendWorldBorderActionPacket(border, SWorldBorderPacket.Action.SET_WARNING_TIME);
    }

    public void onWarningDistanceChanged(WorldBorder border, int newDistance) {
        this.sendWorldBorderActionPacket(border, SWorldBorderPacket.Action.SET_WARNING_BLOCKS);
    }

    public void onDamageAmountChanged(WorldBorder border, double newAmount) {
    }

    public void onDamageBufferChanged(WorldBorder border, double newSize) {
    }

    private void sendWorldBorderActionPacket(WorldBorder border, SWorldBorderPacket.Action action) {
        SWorldBorderPacket packet = new SWorldBorderPacket(border, action);
        this.world.getPlayers().forEach(player -> player.connection.sendPacket((IPacket)packet));
    }
}

