/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.Cause;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.service.server.permission.SpongeSystemSubject;

public final class ServerConsoleSystemSubject
extends SpongeSystemSubject
implements CommandSourceProviderBridge,
ICommandSource {
    @Override
    public String getIdentifier() {
        return "console";
    }

    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType type) {
        SpongeCommon.getServer().sendMessage(SpongeAdventure.asVanilla(message));
    }

    @Override
    public CommandSource bridge$getCommandSource(Cause cause) {
        return new CommandSource((ICommandSource)this, Vec3d.ZERO, Vec2f.ZERO, SpongeCommon.getServer().getWorld(DimensionType.OVERWORLD), 4, "System Subject", (ITextComponent)new StringTextComponent("System Subject"), SpongeCommon.getServer(), null);
    }

    public void sendMessage(ITextComponent component) {
        SpongeCommon.getLogger().info(component.getString());
    }

    public boolean shouldReceiveFeedback() {
        return true;
    }

    public boolean shouldReceiveErrors() {
        return true;
    }

    public boolean allowLogging() {
        return true;
    }
}

