/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.common.service.game.pagination.ActivePagination;
import org.spongepowered.common.service.game.pagination.SpongePaginationBuilder;

@Singleton
public final class SpongePaginationService
implements PaginationService {
    private final ConcurrentMap<Audience, SourcePaginations> activePaginations = new MapMaker().weakKeys().makeMap();
    private final Cache<UUID, SourcePaginations> playerActivePaginations = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Override
    public PaginationList.Builder builder() {
        return new SpongePaginationBuilder(this);
    }

    @Nullable
    SourcePaginations getPaginationState(Audience source, boolean create) {
        if (source instanceof Player) {
            return this.getPaginationStateForPlayer((Player)source, create);
        }
        return this.getPaginationStateForNonPlayer(source, create);
    }

    @Nullable
    private SourcePaginations getPaginationStateForNonPlayer(Audience source, boolean create) {
        SourcePaginations existing;
        SourcePaginations ret = (SourcePaginations)this.activePaginations.get(source);
        if (ret == null && create && (existing = this.activePaginations.putIfAbsent(source, ret = new SourcePaginations())) != null) {
            ret = existing;
        }
        return ret;
    }

    @Nullable
    private SourcePaginations getPaginationStateForPlayer(Player source, boolean create) {
        return (SourcePaginations)this.playerActivePaginations.get((Object)source.getUniqueId(), k -> create ? new SourcePaginations() : null);
    }

    public Command.Parameterized createPaginationCommand() {
        Parameter.Value<ActivePagination> paginationIdParameter = Parameter.builder(ActivePagination.class).parser(new ActivePaginationParameter()).setKey("pagination-id").build();
        Command.Parameterized next = Command.builder().setShortDescription((Component)Component.text((String)"Go to the next page")).setExecutor(context -> {
            ((ActivePagination)context.requireOne(paginationIdParameter)).nextPage();
            return CommandResult.success();
        }).build();
        Command.Parameterized prev = Command.builder().setShortDescription((Component)Component.text((String)"Go to the previous page")).setExecutor(context -> {
            ((ActivePagination)context.requireOne(paginationIdParameter)).previousPage();
            return CommandResult.success();
        }).build();
        Parameter.Value<Integer> pageParameter = Parameter.integerNumber().setKey("page").build();
        CommandExecutor pageExecutor = context -> {
            ((ActivePagination)context.requireOne(paginationIdParameter)).specificPage((Integer)context.requireOne(pageParameter));
            return CommandResult.success();
        };
        Command.Parameterized page = Command.builder().setShortDescription((Component)Component.text((String)"Go to a specific page")).parameter(pageParameter).setExecutor(pageExecutor).build();
        return Command.builder().parameters(paginationIdParameter, Parameter.firstOf(pageParameter, Parameter.subcommand(next, "next", "n"), Parameter.subcommand(prev, "prev", "p", "previous"), Parameter.subcommand(page, "page", new String[0]))).child(page, "page").setShortDescription((Component)Component.text((String)"Helper command for paginations occurring")).setExecutor(pageExecutor).build();
    }

    private final class ActivePaginationParameter
    implements ValueParameter<ActivePagination>,
    ValueCompleter {
        private ActivePaginationParameter() {
        }

        @Override
        public Optional<? extends ActivePagination> getValue(Parameter.Key<? super ActivePagination> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
            UUID id;
            Audience source = context.getCause().getAudience();
            SourcePaginations paginations = SpongePaginationService.this.getPaginationState(source, false);
            if (paginations == null) {
                String name = source instanceof Nameable ? ((Nameable)source).getName() : source.toString();
                throw reader.createException((Component)Component.text((String)String.format("Source %s has no paginations!", name)));
            }
            ArgumentReader.Immutable state = reader.getImmutable();
            try {
                id = UUID.fromString(reader.parseString());
            }
            catch (IllegalArgumentException ex) {
                if (paginations.getLastUuid() != null) {
                    reader.setState(state);
                    return Optional.ofNullable(paginations.get(paginations.getLastUuid()));
                }
                throw reader.createException((Component)Component.text((String)"Input was not a valid UUID!"));
            }
            ActivePagination pagination = paginations.get(id);
            if (pagination == null) {
                throw reader.createException((Component)Component.text((String)("No pagination registered for id " + id)));
            }
            return Optional.ofNullable(paginations.get(id));
        }

        @Override
        public List<String> complete(CommandContext context, String input) {
            Audience audience = context.getCause().getAudience();
            SourcePaginations paginations = SpongePaginationService.this.getPaginationState(audience, false);
            if (paginations != null) {
                return paginations.keys().stream().map(Object::toString).filter(x -> x.startsWith(input)).collect(Collectors.toList());
            }
            return ImmutableList.of();
        }
    }

    static final class SourcePaginations {
        private final Map<UUID, ActivePagination> paginations = new ConcurrentHashMap<UUID, ActivePagination>();
        @Nullable
        private volatile UUID lastUuid;

        SourcePaginations() {
        }

        @Nullable
        public ActivePagination get(UUID uuid) {
            return this.paginations.get(uuid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ActivePagination pagination) {
            Map<UUID, ActivePagination> map = this.paginations;
            synchronized (map) {
                this.paginations.put(pagination.getId(), pagination);
                this.lastUuid = pagination.getId();
            }
        }

        public Set<UUID> keys() {
            return this.paginations.keySet();
        }

        @Nullable
        public UUID getLastUuid() {
            return this.lastUuid;
        }
    }
}

