/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.whitelist.WhitelistService;
import org.spongepowered.common.applaunch.config.common.ServicesCategory;
import org.spongepowered.common.event.lifecycle.ProvideEngineServiceEventImpl;
import org.spongepowered.common.event.lifecycle.ProvideServiceEventImpl;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.common.service.server.ban.SpongeBanService;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.whitelist.SpongeWhitelistService;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeServerScopedServiceProvider
extends SpongeServiceProvider
implements ServiceProvider.ServerScoped {
    private final Server server;

    @Inject
    public SpongeServerScopedServiceProvider(Server server, Game game, Injector injector) {
        super(game, injector);
        this.server = server;
    }

    @Override
    protected List<SpongeServiceProvider.Service<?>> servicesToSelect() {
        return ImmutableList.builder().add(new SpongeServiceProvider.Service<SpongeBanService>(BanService.class, ServicesCategory.ServicePluginSubCategory::getBanService, SpongeBanService.class)).add(new SpongeServiceProvider.Service<EconomyService>(EconomyService.class, ServicesCategory.ServicePluginSubCategory::getEconomyService, null)).add(new SpongeServiceProvider.Service<SpongePermissionService>(PermissionService.class, ServicesCategory.ServicePluginSubCategory::getPermissionService, SpongePermissionService.class)).add(new SpongeServiceProvider.Service<SpongeWhitelistService>(WhitelistService.class, ServicesCategory.ServicePluginSubCategory::getWhitelistService, SpongeWhitelistService.class)).build();
    }

    @Override
    protected <T> ProvideServiceEventImpl<T> createEvent(PluginContainer container, SpongeServiceProvider.Service<T> service) {
        return new ProvideEngineServiceEventImpl<T>(Cause.of(EventContext.empty(), this.getGame()), this.getGame(), TypeToken.get(service.getServiceClass()), this.server);
    }

    @Override
    public final @NonNull BanService banService() {
        return this.provideUnchecked(BanService.class);
    }

    @Override
    public final @NonNull Optional<EconomyService> economyService() {
        return this.provide(EconomyService.class);
    }

    @Override
    public final @NonNull PermissionService permissionService() {
        return this.provideUnchecked(PermissionService.class);
    }

    @Override
    public final @NonNull WhitelistService whitelistService() {
        return this.provideUnchecked(WhitelistService.class);
    }
}

