/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.UserList;
import net.minecraft.server.management.UserListEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.management.UserListAccessor;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeBanService
implements BanService {
    public Collection<Ban> getBans() {
        Collection<Ban> bans = this.getProfileBans();
        bans.addAll(this.getIpBans());
        return bans;
    }

    @Override
    public Collection<Ban.Profile> getProfileBans() {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.accessor$removeExpired();
        return new ArrayList<Ban.Profile>(accessor.accessor$getValues().values());
    }

    @Override
    public Collection<Ban.Ip> getIpBans() {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.accessor$removeExpired();
        return new ArrayList<Ban.Ip>(accessor.accessor$getValues().values());
    }

    @Override
    public Optional<Ban.Profile> getBanFor(GameProfile profile) {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.accessor$removeExpired();
        return Optional.ofNullable((Ban.Profile)accessor.accessor$getValues().get(accessor.accessor$getObjectKey(SpongeGameProfile.toMcProfile(profile))));
    }

    @Override
    public Optional<Ban.Ip> getBanFor(InetAddress address) {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.accessor$removeExpired();
        return Optional.ofNullable((Ban.Ip)accessor.accessor$getValues().get(accessor.accessor$getObjectKey(((IPBanList)accessor).addressToString((SocketAddress)new InetSocketAddress(address, 0)))));
    }

    @Override
    public boolean isBanned(GameProfile profile) {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.accessor$removeExpired();
        return accessor.accessor$getValues().containsKey(accessor.accessor$getObjectKey(SpongeGameProfile.toMcProfile(profile)));
    }

    @Override
    public boolean isBanned(InetAddress address) {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.accessor$removeExpired();
        return accessor.accessor$getValues().containsKey(accessor.accessor$getObjectKey(((IPBanList)accessor).addressToString((SocketAddress)new InetSocketAddress(address, 0))));
    }

    @Override
    public boolean pardon(GameProfile profile) {
        Optional<Ban.Profile> ban = this.getBanFor(profile);
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.accessor$removeExpired();
        return ban.isPresent() && this.removeBan(ban.get());
    }

    @Override
    public boolean pardon(InetAddress address) {
        Optional<Ban.Ip> ban = this.getBanFor(address);
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.accessor$removeExpired();
        return ban.isPresent() && this.removeBan(ban.get());
    }

    @Override
    public boolean removeBan(Ban ban) {
        if (!this.hasBan(ban)) {
            return false;
        }
        if (ban.getType().equals(BanTypes.PROFILE.get())) {
            User user = Sponge.getServer().getUserManager().getOrCreate(((Ban.Profile)ban).getProfile());
            Sponge.getEventManager().post(SpongeEventFactory.createPardonUserEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Profile)ban, user));
            UserListUtil.removeEntry((UserList)this.getUserBanList(), ((Ban.Profile)ban).getProfile());
            return true;
        }
        if (ban.getType().equals(BanTypes.IP.get())) {
            Sponge.getEventManager().post(SpongeEventFactory.createPardonIpEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Ip)ban));
            InetSocketAddress inetSocketAddress = new InetSocketAddress(((Ban.Ip)ban).getAddress(), 0);
            UserListUtil.removeEntry((UserList)this.getIPBanList(), this.getIPBanList().addressToString((SocketAddress)inetSocketAddress));
            return true;
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    @Override
    public Optional<? extends Ban> addBan(Ban ban) {
        Optional<Ban> prevBan;
        if (ban.getType().equals(BanTypes.PROFILE.get())) {
            prevBan = this.getBanFor(((Ban.Profile)ban).getProfile());
            User user = Sponge.getServer().getUserManager().getOrCreate(((Ban.Profile)ban).getProfile());
            Sponge.getEventManager().post(SpongeEventFactory.createBanUserEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Profile)ban, user));
            UserListUtil.addEntry((UserList)this.getUserBanList(), (UserListEntry)ban);
        } else if (ban.getType().equals(BanTypes.IP.get())) {
            prevBan = this.getBanFor(((Ban.Ip)ban).getAddress());
            Sponge.getEventManager().post(SpongeEventFactory.createBanIpEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Ip)ban));
            UserListUtil.addEntry((UserList)this.getIPBanList(), (UserListEntry)ban);
        } else {
            throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
        }
        return prevBan;
    }

    @Override
    public boolean hasBan(Ban ban) {
        if (ban.getType().equals(BanTypes.PROFILE)) {
            return this.isBanned(((Ban.Profile)ban).getProfile());
        }
        if (ban.getType().equals(BanTypes.IP)) {
            return this.isBanned(((Ban.Ip)ban).getAddress());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    private BanList getUserBanList() {
        return SpongeCommon.getServer().getPlayerList().getBannedPlayers();
    }

    private IPBanList getIPBanList() {
        return SpongeCommon.getServer().getPlayerList().getBannedIPs();
    }
}

