/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;

public abstract class SpongeSubjectCollection
implements SubjectCollection {
    private final String identifier;
    protected final SpongePermissionService service;

    protected SpongeSubjectCollection(String identifier, SpongePermissionService service) {
        this.identifier = identifier;
        this.service = service;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Predicate<String> getIdentifierValidityPredicate() {
        return s2 -> true;
    }

    @Override
    public SubjectReference newSubjectReference(String subjectIdentifier) {
        return this.service.newSubjectReference(this.getIdentifier(), subjectIdentifier);
    }

    public abstract SpongeSubject get(String var1);

    public abstract boolean isRegistered(String var1);

    @Override
    public CompletableFuture<Subject> loadSubject(String identifier) {
        return CompletableFuture.completedFuture(this.get(identifier));
    }

    @Override
    public Optional<Subject> getSubject(String identifier) {
        return Optional.of(this.get(identifier));
    }

    @Override
    public CompletableFuture<Boolean> hasSubject(String identifier) {
        return CompletableFuture.completedFuture(this.isRegistered(identifier));
    }

    @Override
    public CompletableFuture<Map<String, Subject>> loadSubjects(Set<String> identifiers) {
        HashMap<String, SpongeSubject> ret = new HashMap<String, SpongeSubject>();
        for (String id : identifiers) {
            ret.put(id, this.get(id));
        }
        return CompletableFuture.completedFuture(ImmutableMap.copyOf(ret));
    }

    @Override
    public Map<Subject, Boolean> getLoadedWithPermission(String permission) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subj : this.getLoadedSubjects()) {
            Tristate state = subj.getPermissionValue(subj.getActiveContexts(), permission);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subj, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Map<Subject, Boolean> getLoadedWithPermission(Set<Context> contexts, String permission) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subj : this.getLoadedSubjects()) {
            Tristate state = subj.getPermissionValue(contexts, permission);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subj, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @Override
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(Set<Context> contexts, String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(contexts, permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @Override
    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(this.getLoadedSubjects().stream().map(Contextual::getIdentifier).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public SpongeSubject getDefaults() {
        return this.service.getDefaultCollection().get(this.getIdentifier());
    }

    @Override
    public void suggestUnload(String identifier) {
    }
}

